/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.domain;

import de.ii.xtraplatform.features.domain.FeatureEventHandler;
import de.ii.xtraplatform.features.domain.FeatureSchema;
import de.ii.xtraplatform.features.domain.FeatureTokenTransformer;
import de.ii.xtraplatform.features.domain.ImmutableFeatureSchema;
import de.ii.xtraplatform.features.domain.NestingTracker;
import de.ii.xtraplatform.features.domain.SchemaBase;
import de.ii.xtraplatform.features.domain.SchemaMapping;
import de.ii.xtraplatform.features.domain.transform.FeaturePropertyContextTransformer;
import de.ii.xtraplatform.features.domain.transform.FeaturePropertySchemaTransformer;
import de.ii.xtraplatform.features.domain.transform.FeaturePropertyTransformerFlatten;
import de.ii.xtraplatform.features.domain.transform.PropertyTransformations;
import de.ii.xtraplatform.features.domain.transform.TransformerChain;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadow.com.google.common.collect.ImmutableList;

public class FeatureTokenTransformerSchemaMappings
extends FeatureTokenTransformer {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureTokenTransformerSchemaMappings.class);
    private final PropertyTransformations propertyTransformations;
    private FeatureEventHandler.ModifiableContext<FeatureSchema, SchemaMapping> newContext;
    private NestingTracker nestingTracker;
    private TransformerChain<FeatureSchema, FeaturePropertySchemaTransformer> schemaTransformerChain;
    private TransformerChain<FeatureEventHandler.ModifiableContext<FeatureSchema, SchemaMapping>, FeaturePropertyContextTransformer> contextTransformerChain;
    private final List<List<String>> indexedArrays;
    private final List<List<String>> openedArrays;

    public FeatureTokenTransformerSchemaMappings(PropertyTransformations propertyTransformations) {
        this.propertyTransformations = propertyTransformations;
        this.indexedArrays = new ArrayList<List<String>>();
        this.openedArrays = new ArrayList<List<String>>();
    }

    @Override
    public void onStart(FeatureEventHandler.ModifiableContext<FeatureSchema, SchemaMapping> context) {
        SchemaMapping schemaMapping = SchemaMapping.withTargetPaths((SchemaMapping)this.getContext().mapping());
        this.newContext = this.createContext().setMapping(schemaMapping).setQuery(this.getContext().query()).setMetadata(this.getContext().metadata());
        this.schemaTransformerChain = this.propertyTransformations.getSchemaTransformations(schemaMapping, !context.query().returnsSingleFeature(), this::getFlattenedPropertyPath);
        this.contextTransformerChain = this.propertyTransformations.getContextTransformations(schemaMapping);
        boolean flattenObjects = this.schemaTransformerChain.has("*") && this.schemaTransformerChain.get("*").stream().anyMatch(featurePropertySchemaTransformer -> featurePropertySchemaTransformer instanceof FeaturePropertyTransformerFlatten && (((FeaturePropertyTransformerFlatten)featurePropertySchemaTransformer).include() == FeaturePropertyTransformerFlatten.INCLUDE.ALL || ((FeaturePropertyTransformerFlatten)featurePropertySchemaTransformer).include() == FeaturePropertyTransformerFlatten.INCLUDE.OBJECTS));
        boolean flattenArrays = this.schemaTransformerChain.has("*") && this.schemaTransformerChain.get("*").stream().anyMatch(featurePropertySchemaTransformer -> featurePropertySchemaTransformer instanceof FeaturePropertyTransformerFlatten && (((FeaturePropertyTransformerFlatten)featurePropertySchemaTransformer).include() == FeaturePropertyTransformerFlatten.INCLUDE.ALL || ((FeaturePropertyTransformerFlatten)featurePropertySchemaTransformer).include() == FeaturePropertyTransformerFlatten.INCLUDE.ARRAYS));
        this.nestingTracker = new NestingTracker(this.getDownstream(), this.newContext, ImmutableList.of(), flattenObjects, flattenArrays, true);
        if (flattenObjects) {
            this.newContext.putTransformed("FLATTEN", "TRUE");
        }
        this.getDownstream().onStart(this.newContext);
    }

    @Override
    public void onEnd(FeatureEventHandler.ModifiableContext<FeatureSchema, SchemaMapping> context) {
        this.getDownstream().onEnd(this.newContext);
    }

    @Override
    public void onFeatureStart(FeatureEventHandler.ModifiableContext<FeatureSchema, SchemaMapping> context) {
        this.getDownstream().onFeatureStart(this.newContext);
    }

    @Override
    public void onFeatureEnd(FeatureEventHandler.ModifiableContext<FeatureSchema, SchemaMapping> context) {
        while (this.nestingTracker.isNested()) {
            if (this.nestingTracker.inObject()) {
                this.closeObject();
                continue;
            }
            if (!this.nestingTracker.inArray()) continue;
            this.closeArray();
        }
        this.getDownstream().onFeatureEnd(this.newContext);
    }

    @Override
    public void onObjectStart(FeatureEventHandler.ModifiableContext<FeatureSchema, SchemaMapping> context) {
        if (context.schema().filter(SchemaBase::isSpatial).isPresent()) {
            this.handleNesting((FeatureSchema)context.schema().get(), context.parentSchemas(), context.indexes());
            this.newContext.pathTracker().track(((FeatureSchema)context.schema().get()).getFullPath());
            this.newContext.setInGeometry(true);
            this.newContext.setGeometryType(context.geometryType());
            this.newContext.setGeometryDimension(context.geometryDimension());
            if (context.geometryType().isPresent() && ((FeatureSchema)context.schema().get()).getGeometryType().isPresent() && context.geometryType().get() != ((FeatureSchema)context.schema().get()).getGeometryType().get()) {
                this.newContext.setCustomSchema(new ImmutableFeatureSchema.Builder().from((FeatureSchema)context.schema().get()).geometryType(context.geometryType().get()).build());
            }
            if (!this.newContext.shouldSkip()) {
                this.getDownstream().onObjectStart(this.newContext);
            }
        }
        if (context.schema().filter(SchemaBase::isObject).isEmpty()) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("OBJECT NOT FOUND {} {}", (Object)context.pathAsString(), Objects.nonNull(context.mapping()) ? ((SchemaMapping)context.mapping()).getTargetSchemasByPath().keySet() : "{}");
            }
            return;
        }
        this.handleNesting((FeatureSchema)context.schema().get(), context.parentSchemas(), context.indexes());
    }

    @Override
    public void onObjectEnd(FeatureEventHandler.ModifiableContext<FeatureSchema, SchemaMapping> context) {
        if (context.schema().filter(SchemaBase::isSpatial).isPresent()) {
            if (!this.newContext.shouldSkip()) {
                this.getDownstream().onObjectEnd(this.newContext);
            }
            this.newContext.setInGeometry(false);
            this.newContext.setGeometryType(Optional.empty());
            this.newContext.setGeometryDimension(OptionalInt.empty());
        }
    }

    @Override
    public void onArrayStart(FeatureEventHandler.ModifiableContext<FeatureSchema, SchemaMapping> context) {
        if (context.inGeometry() && !this.newContext.shouldSkip()) {
            this.getDownstream().onArrayStart(this.newContext);
        }
        if (context.schema().filter(SchemaBase::isArray).isEmpty()) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("ARRAY NOT FOUND {} {}", (Object)context.pathAsString(), Objects.nonNull(context.mapping()) ? ((SchemaMapping)context.mapping()).getTargetSchemasByPath().keySet() : "{}");
            }
            return;
        }
        this.handleNesting((FeatureSchema)context.schema().get(), context.parentSchemas(), context.indexes());
    }

    @Override
    public void onArrayEnd(FeatureEventHandler.ModifiableContext<FeatureSchema, SchemaMapping> context) {
        if (context.inGeometry() && !this.newContext.shouldSkip()) {
            this.getDownstream().onArrayEnd(this.newContext);
        }
    }

    @Override
    public void onValue(FeatureEventHandler.ModifiableContext<FeatureSchema, SchemaMapping> context) {
        if (context.inGeometry()) {
            this.newContext.setValue(context.value());
            this.newContext.setValueType(context.valueType());
            this.pushValue();
            return;
        }
        if (context.schema().isEmpty()) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("VALUE NOT FOUND {} {}", (Object)context.pathAsString(), Objects.nonNull(context.mapping()) ? ((SchemaMapping)context.mapping()).getTargetSchemasByPath().keySet() : "{}");
            }
            return;
        }
        FeatureSchema schema = (FeatureSchema)context.schema().get();
        if (schema.getEffectiveSourcePaths().size() > 1) {
            String column = context.path().get(context.path().size() - 1);
            if (schema.isArray()) {
                int index = schema.getEffectiveSourcePaths().indexOf(column);
                if (index >= 0) {
                    ArrayList<Integer> indexes = new ArrayList<Integer>(index == 0 ? context.indexes() : context.indexes().subList(0, context.indexes().size() - 1));
                    indexes.add(index + 1);
                    context.setIndexes(indexes);
                }
            } else {
                if (Objects.nonNull(context.value())) {
                    this.newContext.putValueBuffer(context.pathAsString(), context.value());
                    this.newContext.putValueBuffer(column, context.value());
                }
                if (!Objects.equals(schema.getEffectiveSourcePaths().get(schema.getEffectiveSourcePaths().size() - 1), column)) {
                    return;
                }
            }
        }
        this.handleNesting(schema, context.parentSchemas(), context.indexes());
        this.newContext.pathTracker().track(schema.getFullPath());
        this.newContext.setValue(context.value());
        this.newContext.setValueType(context.valueType());
        this.contextTransformerChain.transform(this.newContext.pathAsString(), this.newContext);
        FeatureSchema transformed = this.schemaTransformerChain.transform(this.newContext.pathAsString(), schema);
        if (Objects.isNull(transformed)) {
            this.clearValueContext();
            return;
        }
        this.newContext.setCustomSchema(transformed);
        this.pushValue();
    }

    private void pushValue() {
        try {
            if (!this.newContext.shouldSkip()) {
                this.getDownstream().onValue(this.newContext);
            }
        }
        finally {
            this.clearValueContext();
        }
    }

    private void clearValueContext() {
        this.newContext.setCustomSchema(null);
        this.newContext.setValue(null);
        this.newContext.setValueType(null);
    }

    private void handleNesting(FeatureSchema schema, List<FeatureSchema> parentSchemas, List<Integer> indexes) {
        while (this.nestingTracker.isNested() && (this.nestingTracker.doesNotStartWithPreviousPath(schema.getFullPath()) || this.nestingTracker.inArray() && this.nestingTracker.isSamePath(schema.getFullPath()) && this.nestingTracker.hasParentIndexChanged(indexes))) {
            if (this.nestingTracker.inObject()) {
                this.closeObject();
                continue;
            }
            if (!this.nestingTracker.inArray()) continue;
            this.closeArray();
        }
        if (this.nestingTracker.inObject() && this.newContext.inArray() && this.nestingTracker.isSamePath(schema.getFullPath()) && this.nestingTracker.hasIndexChanged(indexes)) {
            this.closeObject();
            this.newContext.setIndexes(indexes);
            this.openObject(schema);
        }
        if (schema.isArray() && !this.nestingTracker.isSamePath(schema.getFullPath())) {
            this.openParents(parentSchemas, indexes);
            this.newContext.pathTracker().track(schema.getFullPath());
            this.openArray(schema);
        } else if (schema.isObject() && schema.isArray() && this.nestingTracker.isFirst(indexes)) {
            this.newContext.pathTracker().track(schema.getFullPath());
            this.newContext.setIndexes(indexes);
            this.openObject(schema);
        } else if (schema.isObject() && !schema.isArray() && !this.nestingTracker.isSamePath(schema.getFullPath())) {
            this.openParents(parentSchemas, indexes);
            this.newContext.pathTracker().track(schema.getFullPath());
            this.openObject(schema);
        } else if (schema.isValue() && (!schema.isArray() || this.nestingTracker.isFirst(indexes))) {
            this.openParents(parentSchemas, indexes);
        }
        if (schema.isValue() && schema.isArray()) {
            this.newContext.setIndexes(indexes);
        }
    }

    private void openObject(FeatureSchema schema) {
        this.contextTransformerChain.transform(this.newContext.pathAsString(), this.newContext);
        FeatureSchema transform1 = this.schemaTransformerChain.transform(this.newContext.pathAsString(), schema);
        if (Objects.isNull(transform1)) {
            this.newContext.setCustomSchema(null);
            return;
        }
        this.newContext.setCustomSchema(transform1);
        this.nestingTracker.openObject();
        this.newContext.setCustomSchema(null);
    }

    private void openArray(FeatureSchema schema) {
        this.contextTransformerChain.transform(this.newContext.pathAsString(), this.newContext);
        FeatureSchema transform1 = this.schemaTransformerChain.transform(this.newContext.pathAsString(), schema);
        if (Objects.isNull(transform1)) {
            this.newContext.setCustomSchema(null);
            return;
        }
        this.newContext.setCustomSchema(transform1);
        this.nestingTracker.openArray();
        this.newContext.setCustomSchema(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void closeObject() {
        this.newContext.pathTracker().track(this.nestingTracker.getCurrentNestingPath());
        String path = this.newContext.pathAsString();
        if (this.newContext.transformed().containsKey(path) && this.newContext.transformed().get(path).equals("REDUCE")) {
            this.contextTransformerChain.transform(path, this.newContext);
            try {
                if (this.newContext.shouldSkip()) return;
                this.getDownstream().onValue(this.newContext);
                return;
            }
            catch (Throwable e) {
                throw e;
            }
            finally {
                this.newContext.setCustomSchema(null);
                this.newContext.setValue(null);
                this.newContext.setValueType(null);
                this.newContext.valueBuffer().clear();
                this.newContext.setIsBuffering(true);
                this.nestingTracker.closeObject();
                this.newContext.setIsBuffering(false);
            }
        } else {
            this.nestingTracker.closeObject();
        }
    }

    private void closeArray() {
        this.newContext.pathTracker().track(this.nestingTracker.getCurrentNestingPath());
        this.nestingTracker.closeArray();
    }

    private void openParents(List<FeatureSchema> parentSchemas, List<Integer> indexes) {
        if (parentSchemas.size() < 2) {
            return;
        }
        FeatureSchema parent = parentSchemas.get(0);
        if (parent.getSourcePath().isPresent()) {
            return;
        }
        ArrayList<Integer> newIndexes = new ArrayList<Integer>(this.newContext.indexes());
        ArrayList<List<String>> arrays = new ArrayList<List<String>>();
        for (int i = parentSchemas.size() - 1; i >= 0; --i) {
            FeatureSchema schema = parentSchemas.get(i);
            if (schema.getType() != SchemaBase.Type.OBJECT_ARRAY || !schema.getSourcePath().isEmpty()) continue;
            arrays.add(schema.getFullPath());
            if (this.indexedArrays.contains(schema.getFullPath())) continue;
            this.indexedArrays.add(schema.getFullPath());
            newIndexes.add(1);
            this.newContext.setIndexes(newIndexes);
        }
        this.indexedArrays.removeIf(strings -> !arrays.contains(strings));
        this.openedArrays.removeIf(strings -> !arrays.contains(strings));
        if (parent.isArray()) {
            if (!this.openedArrays.contains(parent.getFullPath())) {
                this.handleNesting(parent, parentSchemas.subList(1, parentSchemas.size()), newIndexes);
                if (parent.isObject()) {
                    this.handleNesting(parent, parentSchemas.subList(1, parentSchemas.size()), newIndexes);
                }
                this.openedArrays.add(parent.getFullPath());
            }
        } else if (parent.isObject()) {
            this.handleNesting(parent, parentSchemas.subList(1, parentSchemas.size()), newIndexes);
        }
    }

    private String getFlattenedPropertyPath(String separator, String name) {
        return this.nestingTracker.getFlattenedPropertyPath(separator, name);
    }
}

