/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.domain;

import de.ii.xtraplatform.features.domain.FeatureEventHandler;
import de.ii.xtraplatform.features.domain.FeatureSchema;
import de.ii.xtraplatform.features.domain.FeatureTokenTransformer;
import de.ii.xtraplatform.features.domain.SchemaMapping;
import java.util.ArrayList;
import java.util.List;

public class FeatureTokenTransformerRemoveEmptyOptionals
extends FeatureTokenTransformer {
    private final List<String> nestingStack = new ArrayList<String>();
    private final List<FeatureSchema> schemaStack = new ArrayList<FeatureSchema>();
    private final List<FeatureSchema> customSchemaStack = new ArrayList<FeatureSchema>();

    @Override
    public void onObjectStart(FeatureEventHandler.ModifiableContext<FeatureSchema, SchemaMapping> context) {
        if (context.inGeometry()) {
            this.openIfNecessary(context);
            super.onObjectStart(context);
            return;
        }
        FeatureSchema schema = (FeatureSchema)context.schema().get();
        if (schema.isRequired() && this.schemaStack.isEmpty()) {
            this.getDownstream().onObjectStart(context);
        } else {
            this.nestingStack.add("O");
            this.schemaStack.add(schema);
            this.customSchemaStack.add((FeatureSchema)context.customSchema());
        }
    }

    @Override
    public void onObjectEnd(FeatureEventHandler.ModifiableContext<FeatureSchema, SchemaMapping> context) {
        if (context.inGeometry()) {
            super.onObjectEnd(context);
            return;
        }
        if (this.schemaStack.isEmpty()) {
            this.getDownstream().onObjectEnd(context);
        } else {
            this.nestingStack.remove(this.nestingStack.size() - 1);
            this.schemaStack.remove(this.schemaStack.size() - 1);
            this.customSchemaStack.remove(this.customSchemaStack.size() - 1);
        }
    }

    @Override
    public void onArrayStart(FeatureEventHandler.ModifiableContext<FeatureSchema, SchemaMapping> context) {
        if (context.inGeometry()) {
            this.openIfNecessary(context);
            super.onArrayStart(context);
            return;
        }
        FeatureSchema schema = (FeatureSchema)context.schema().get();
        if (schema.isRequired() && this.schemaStack.isEmpty()) {
            this.getDownstream().onArrayStart(context);
        } else {
            this.nestingStack.add("A");
            this.schemaStack.add(schema);
            this.customSchemaStack.add((FeatureSchema)context.customSchema());
        }
    }

    @Override
    public void onArrayEnd(FeatureEventHandler.ModifiableContext<FeatureSchema, SchemaMapping> context) {
        if (context.inGeometry()) {
            super.onArrayEnd(context);
            return;
        }
        if (this.schemaStack.isEmpty()) {
            this.getDownstream().onArrayEnd(context);
        } else {
            this.nestingStack.remove(this.nestingStack.size() - 1);
            this.schemaStack.remove(this.schemaStack.size() - 1);
            this.customSchemaStack.remove(this.customSchemaStack.size() - 1);
        }
    }

    @Override
    public void onValue(FeatureEventHandler.ModifiableContext<FeatureSchema, SchemaMapping> context) {
        this.openIfNecessary(context);
        super.onValue(context);
    }

    private void openIfNecessary(FeatureEventHandler.ModifiableContext<FeatureSchema, SchemaMapping> context) {
        if (!this.schemaStack.isEmpty()) {
            List<String> previousPath = context.path();
            FeatureSchema previousCustomSchema = (FeatureSchema)context.customSchema();
            for (int i = 0; i < this.schemaStack.size(); ++i) {
                FeatureSchema schema = this.schemaStack.get(i);
                FeatureSchema customSchema = this.customSchemaStack.get(i);
                context.pathTracker().track(schema.getFullPath());
                context.setCustomSchema(customSchema);
                if (this.nestingStack.get(i).equals("A")) {
                    this.getDownstream().onArrayStart(context);
                    context.setInArray(true);
                    continue;
                }
                if (!this.nestingStack.get(i).equals("O")) continue;
                this.getDownstream().onObjectStart(context);
                context.setInObject(true);
            }
            this.nestingStack.clear();
            this.schemaStack.clear();
            this.customSchemaStack.clear();
            context.pathTracker().track(previousPath);
            context.setCustomSchema(previousCustomSchema);
        }
    }
}

