/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.domain;

import de.ii.xtraplatform.features.domain.FeatureEventHandler;
import de.ii.xtraplatform.features.domain.FeatureTokenContext;
import de.ii.xtraplatform.features.domain.FeatureTokenReader;
import de.ii.xtraplatform.features.domain.FeatureTokenSource;
import de.ii.xtraplatform.features.domain.SchemaBase;
import de.ii.xtraplatform.features.domain.SchemaMappingBase;
import de.ii.xtraplatform.streams.domain.Reactive;
import java.util.Objects;
import java.util.function.Consumer;

public abstract class FeatureTokenTransformerBase<T extends SchemaBase<T>, U extends SchemaMappingBase<T>, V extends FeatureEventHandler.ModifiableContext<T, U>>
implements Reactive.TransformerCustomFuseable<Object, FeatureEventHandler>,
Reactive.TransformerCustomSource<Object, Object, FeatureTokenSource>,
FeatureEventHandler<T, U, V>,
FeatureTokenContext<V> {
    private FeatureEventHandler<T, U, V> downstream;
    private FeatureTokenReader<T, U, V> tokenReader;
    private Runnable afterInit;

    @Override
    public Class<? extends FeatureEventHandler> getFusionInterface() {
        return FeatureEventHandler.class;
    }

    @Override
    public final boolean canFuse(Reactive.TransformerCustomFuseableIn<Object, ?, ?> transformerCustomFuseableIn) {
        boolean isTransformerFuseable = Reactive.TransformerCustomFuseable.super.canFuse(transformerCustomFuseableIn);
        if (isTransformerFuseable && transformerCustomFuseableIn instanceof FeatureTokenContext && !FeatureEventHandler.ModifiableContext.class.isAssignableFrom(((FeatureTokenContext)((Object)transformerCustomFuseableIn)).getContextInterface())) {
            throw new IllegalStateException("Cannot fuse FeatureTokenTransformer: " + ((FeatureTokenContext)((Object)transformerCustomFuseableIn)).getContextInterface() + " does not extend " + this.getContextInterface());
        }
        return isTransformerFuseable;
    }

    @Override
    public final void fuse(Reactive.TransformerCustomFuseableIn<Object, ?, ? extends FeatureEventHandler> transformerCustomFuseableIn) {
        if (!this.canFuse(transformerCustomFuseableIn)) {
            throw new IllegalArgumentException();
        }
        if (Objects.isNull(this.downstream)) {
            this.downstream = transformerCustomFuseableIn.fuseableSink();
            transformerCustomFuseableIn.afterInit(this::init);
        }
    }

    @Override
    public final void init(Consumer<Object> push) {
        if (Objects.isNull(this.downstream)) {
            this.downstream = push::accept;
            this.init();
        }
    }

    @Override
    public final void onPush(Object token) {
        this.tokenReader.onToken(token);
    }

    @Override
    public final void onComplete() {
        this.cleanup();
    }

    @Override
    public final FeatureEventHandler<T, U, V> fuseableSink() {
        return this;
    }

    @Override
    public final FeatureTokenSource getCustomSource(Reactive.Source<Object> source) {
        return new FeatureTokenSource(source);
    }

    protected final FeatureEventHandler<T, U, V> getDownstream() {
        return this.downstream;
    }

    @Override
    public void afterInit(Runnable runnable) {
        this.afterInit = runnable;
    }

    protected void init() {
        if (Objects.nonNull(this.afterInit)) {
            this.afterInit.run();
        }
    }

    protected void cleanup() {
    }

    @Override
    public void onStart(V context) {
        this.getDownstream().onStart(context);
    }

    @Override
    public void onEnd(V context) {
        this.getDownstream().onEnd(context);
    }

    @Override
    public void onFeatureStart(V context) {
        this.getDownstream().onFeatureStart(context);
    }

    @Override
    public void onFeatureEnd(V context) {
        this.getDownstream().onFeatureEnd(context);
    }

    @Override
    public void onObjectStart(V context) {
        this.getDownstream().onObjectStart(context);
    }

    @Override
    public void onObjectEnd(V context) {
        this.getDownstream().onObjectEnd(context);
    }

    @Override
    public void onArrayStart(V context) {
        this.getDownstream().onArrayStart(context);
    }

    @Override
    public void onArrayEnd(V context) {
        this.getDownstream().onArrayEnd(context);
    }

    @Override
    public void onValue(V context) {
        this.getDownstream().onValue(context);
    }
}

