/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.domain;

import de.ii.xtraplatform.features.domain.FeatureEventConsumer;
import de.ii.xtraplatform.features.domain.FeatureEventHandler;
import de.ii.xtraplatform.features.domain.FeatureTokenType;
import de.ii.xtraplatform.features.domain.SchemaBase;
import de.ii.xtraplatform.features.domain.SchemaMappingBase;
import de.ii.xtraplatform.geometries.domain.SimpleFeatureGeometry;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class FeatureTokenReader<T extends SchemaBase<T>, U extends SchemaMappingBase<T>, V extends FeatureEventHandler.ModifiableContext<T, U>> {
    private final FeatureEventHandler<T, U, V> eventHandler;
    private FeatureTokenType currentType;
    private int contextIndex;
    private V context;
    private List<String> nestingStack;

    public FeatureTokenReader(FeatureEventConsumer eventConsumer) {
        this.eventHandler = null;
    }

    public FeatureTokenReader(FeatureEventHandler<T, U, V> eventHandler, V context) {
        this.eventHandler = eventHandler;
        this.context = context;
        this.nestingStack = new ArrayList<String>();
    }

    public void onToken(Object token) {
        if (token instanceof FeatureTokenType) {
            if (Objects.nonNull((Object)this.currentType)) {
                this.emitEvent();
            }
            this.initEvent((FeatureTokenType)((Object)token));
        } else {
            this.readContext(token);
        }
        if (token == FeatureTokenType.INPUT_END) {
            this.emitEvent();
        }
    }

    private void initEvent(FeatureTokenType token) {
        this.currentType = token;
        this.contextIndex = 0;
        this.context.pathTracker().track(0);
        this.context.setGeometryType(Optional.empty());
        this.context.setValueType(SchemaBase.Type.UNKNOWN);
        this.context.setValue(null);
        switch (this.currentType) {
            case OBJECT: {
                if (this.inArray()) {
                    this.context.indexes().set(this.context.indexes().size() - 1, this.context.indexes().get(this.context.indexes().size() - 1) + 1);
                }
                this.push("O");
                break;
            }
            case ARRAY: {
                this.context.indexes().add(0);
                this.push("A");
                break;
            }
            case VALUE: {
                if (!this.inArray()) break;
                this.context.indexes().set(this.context.indexes().size() - 1, this.context.indexes().get(this.context.indexes().size() - 1) + 1);
                break;
            }
            case ARRAY_END: {
                this.context.indexes().remove(this.context.indexes().size() - 1);
                this.pop();
                break;
            }
            case OBJECT_END: {
                this.pop();
            }
        }
    }

    private void readContext(Object context) {
        switch (this.currentType) {
            case INPUT: {
                if (this.contextIndex == 0 && context instanceof Boolean) {
                    this.context.metadata().isSingleFeature((Boolean)context);
                    break;
                }
                if (this.contextIndex == 0 && context instanceof Long) {
                    this.context.metadata().numberReturned((Long)context);
                    break;
                }
                if (this.contextIndex != 1 || !(context instanceof Long)) break;
                this.context.metadata().numberMatched((Long)context);
                break;
            }
            case FEATURE: {
                this.tryReadPath(context);
                break;
            }
            case OBJECT: {
                this.tryReadPath(context);
                if (this.contextIndex != 1 || !(context instanceof SimpleFeatureGeometry)) break;
                this.context.setGeometryType((SimpleFeatureGeometry)((Object)context));
                break;
            }
            case ARRAY: {
                this.tryReadPath(context);
                break;
            }
            case VALUE: {
                this.tryReadPath(context);
                if (this.contextIndex == 1 && context instanceof String) {
                    this.context.setValue((String)context);
                    break;
                }
                if (this.contextIndex != 2 || !(context instanceof SchemaBase.Type)) break;
                this.context.setValueType((SchemaBase.Type)((Object)context));
                break;
            }
        }
        ++this.contextIndex;
    }

    private void tryReadPath(Object context) {
        if (this.contextIndex == 0 && context instanceof List) {
            this.context.pathTracker().track((List)context);
        }
    }

    private void emitEvent() {
        switch (this.currentType) {
            case INPUT: {
                this.eventHandler.onStart(this.context);
                break;
            }
            case FEATURE: {
                this.eventHandler.onFeatureStart(this.context);
                break;
            }
            case OBJECT: {
                this.eventHandler.onObjectStart(this.context);
                break;
            }
            case ARRAY: {
                this.eventHandler.onArrayStart(this.context);
                break;
            }
            case VALUE: {
                this.eventHandler.onValue(this.context);
                break;
            }
            case ARRAY_END: {
                this.eventHandler.onArrayEnd(this.context);
                break;
            }
            case OBJECT_END: {
                this.eventHandler.onObjectEnd(this.context);
                break;
            }
            case FEATURE_END: {
                this.eventHandler.onFeatureEnd(this.context);
                break;
            }
            case INPUT_END: {
                this.eventHandler.onEnd(this.context);
            }
        }
    }

    private boolean inArray() {
        return !this.nestingStack.isEmpty() && this.nestingStack.get(this.nestingStack.size() - 1).equals("A");
    }

    private void push(String type) {
        this.nestingStack.add(type);
    }

    private void pop() {
        this.nestingStack.remove(this.nestingStack.size() - 1);
    }
}

