/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.domain;

import de.ii.xtraplatform.features.domain.FeatureEventHandler;
import de.ii.xtraplatform.features.domain.FeatureTokenType;
import de.ii.xtraplatform.features.domain.SchemaBase;
import de.ii.xtraplatform.features.domain.SchemaMappingBase;
import java.util.Objects;

public interface FeatureTokenEmitter2<T extends SchemaBase<T>, U extends SchemaMappingBase<T>, V extends FeatureEventHandler.ModifiableContext<T, U>>
extends FeatureEventHandler<T, U, V> {
    public void push(Object var1);

    @Override
    default public void onStart(V context) {
        this.push((Object)FeatureTokenType.INPUT);
        if (context.metadata().isSingleFeature()) {
            this.push(true);
        } else {
            if (context.metadata().getNumberReturned().isPresent()) {
                this.push(context.metadata().getNumberReturned().getAsLong());
            }
            if (context.metadata().getNumberMatched().isPresent()) {
                this.push(context.metadata().getNumberMatched().getAsLong());
            }
        }
    }

    @Override
    default public void onEnd(V context) {
        this.push((Object)FeatureTokenType.INPUT_END);
    }

    @Override
    default public void onFeatureStart(V context) {
        this.push((Object)FeatureTokenType.FEATURE);
        if (!context.path().isEmpty()) {
            this.push(context.path());
        }
    }

    @Override
    default public void onFeatureEnd(V context) {
        this.push((Object)FeatureTokenType.FEATURE_END);
    }

    @Override
    default public void onObjectStart(V context) {
        this.push((Object)FeatureTokenType.OBJECT);
        this.push(context.path());
        if (context.geometryType().isPresent()) {
            this.push((Object)context.geometryType().get());
        }
    }

    @Override
    default public void onObjectEnd(V context) {
        this.push((Object)FeatureTokenType.OBJECT_END);
    }

    @Override
    default public void onArrayStart(V context) {
        this.push((Object)FeatureTokenType.ARRAY);
        this.push(context.path());
    }

    @Override
    default public void onArrayEnd(V context) {
        this.push((Object)FeatureTokenType.ARRAY_END);
    }

    @Override
    default public void onValue(V context) {
        this.push((Object)FeatureTokenType.VALUE);
        this.push(context.path());
        if (Objects.nonNull(context.value())) {
            this.push(context.value());
            this.push((Object)context.valueType());
        }
    }
}

