/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.domain;

import de.ii.xtraplatform.cql.domain.CqlFilter;
import java.util.List;
import java.util.Optional;
import shadow.com.google.common.base.Preconditions;
import shadow.com.google.common.collect.ImmutableList;
import shadow.org.immutables.value.Value;

@Value.Immutable
@Value.Style(deepImmutablesDetection=true)
public interface FeatureStoreRelation {
    public CARDINALITY getCardinality();

    public String getSourceContainer();

    public String getSourceField();

    public Optional<String> getSourceFilter();

    @Value.Default
    default public String getSourceSortKey() {
        return this.getSourceField();
    }

    public String getTargetContainer();

    public String getTargetField();

    public Optional<String> getTargetFilter();

    public Optional<String> getJunction();

    public Optional<String> getJunctionSource();

    public Optional<String> getJunctionTarget();

    @Value.Check
    default public void check() {
        Preconditions.checkState(this.getCardinality() == CARDINALITY.M_2_N && this.getJunction().isPresent() || !this.getJunction().isPresent(), "when a junction is set, cardinality needs to be M_2_N, when no junction is set, cardinality is not allowed to be M_2_N");
    }

    @Value.Lazy
    default public boolean isOne2One() {
        return this.getCardinality() == CARDINALITY.ONE_2_ONE;
    }

    @Value.Lazy
    default public boolean isOne2N() {
        return this.getCardinality() == CARDINALITY.ONE_2_N;
    }

    @Value.Lazy
    default public boolean isM2N() {
        return this.getCardinality() == CARDINALITY.M_2_N;
    }

    public Optional<CqlFilter> getFilter();

    @Value.Derived
    default public List<String> asPath() {
        if (this.isM2N()) {
            return ImmutableList.of(String.format("[%s=%s]%s", this.getSourceField(), this.getJunctionSource().get(), this.getJunction().get()), String.format("[%s=%s]%s", this.getJunctionTarget().get(), this.getTargetField(), this.getTargetContainer()));
        }
        return ImmutableList.of(String.format("[%s=%s]%s", this.getSourceField(), this.getTargetField(), this.getTargetContainer()));
    }

    public static enum CARDINALITY {
        ONE_2_ONE,
        ONE_2_N,
        M_2_N;

    }
}

