/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.domain;

import de.ii.xtraplatform.features.domain.FeatureStoreAttributesContainer;
import de.ii.xtraplatform.features.domain.FeatureStoreRelation;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import shadow.com.google.common.collect.ImmutableList;
import shadow.org.immutables.value.Value;

@Value.Immutable
@Value.Style(deepImmutablesDetection=true)
public interface FeatureStoreRelatedContainer
extends FeatureStoreAttributesContainer {
    @Override
    @Value.Derived
    default public List<String> getPath() {
        return Stream.concat(Stream.of(this.getInstanceContainerName() + this.getInstanceConnection().get(0).getSourceFilter().orElse("")), this.getInstanceConnection().stream().flatMap(relation -> {
            if (relation.getJunction().isPresent()) {
                return Stream.of(String.format("[%s=%s]%s", relation.getSourceField(), relation.getJunctionSource().get(), relation.getJunction().get()), String.format("[%s=%s]%s", relation.getJunctionTarget().get(), relation.getTargetField(), relation.getTargetContainer()));
            }
            return Stream.of(String.format("[%s=%s]%s%s", relation.getSourceField(), relation.getTargetField(), relation.getTargetContainer(), relation.getTargetFilter().orElse("")));
        })).collect(Collectors.toList());
    }

    public List<FeatureStoreRelation> getInstanceConnection();

    @Override
    @Value.Derived
    default public String getInstanceContainerName() {
        return this.getInstanceConnection().get(0).getSourceContainer();
    }

    @Override
    @Value.Derived
    @Value.Auxiliary
    default public List<String> getSortKeys() {
        ImmutableList.Builder keys = ImmutableList.builder();
        FeatureStoreRelation previousRelation = null;
        for (int i = 0; i < this.getInstanceConnection().size(); ++i) {
            FeatureStoreRelation relation = this.getInstanceConnection().get(i);
            if (i == 0 || previousRelation.isM2N() || previousRelation.isOne2N()) {
                keys.add(String.format("%s.%s", relation.getSourceContainer(), relation.getSourceSortKey()));
            }
            previousRelation = relation;
        }
        keys.add(String.format("%s.%s", this.getName(), this.getSortKey()));
        return keys.build();
    }

    default public List<String> getSortKeys(ListIterator<String> aliasesIterator) {
        ImmutableList.Builder keys = ImmutableList.builder();
        int keyIndex = 0;
        FeatureStoreRelation previousRelation = null;
        for (int i = 0; i < this.getInstanceConnection().size(); ++i) {
            FeatureStoreRelation relation = this.getInstanceConnection().get(i);
            String alias = aliasesIterator.next();
            if (relation.isM2N()) {
                aliasesIterator.next();
            }
            if (i == 0 || previousRelation.isM2N() || previousRelation.isOne2N()) {
                Object suffix = keyIndex > 0 ? "_" + keyIndex : "";
                keys.add(String.format("%s.%s AS SKEY%s", alias, relation.getSourceSortKey(), suffix));
                ++keyIndex;
            }
            previousRelation = relation;
        }
        keys.add(String.format("%s.%s AS SKEY_%d", aliasesIterator.next(), this.getSortKey(), keyIndex));
        return keys.build();
    }
}

