/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.domain;

import de.ii.xtraplatform.cql.domain.CqlFilter;
import de.ii.xtraplatform.features.domain.FeatureStoreAttribute;
import de.ii.xtraplatform.features.domain.FeatureStoreAttributesContainer;
import de.ii.xtraplatform.features.domain.FeatureStoreRelatedContainer;
import java.util.List;
import java.util.Optional;
import shadow.com.google.common.collect.ImmutableList;
import shadow.org.immutables.value.Value;

@Value.Immutable
@Value.Style(deepImmutablesDetection=true)
public interface FeatureStoreInstanceContainer
extends FeatureStoreAttributesContainer {
    @Override
    @Value.Derived
    default public List<String> getPath() {
        return ImmutableList.of(this.getName());
    }

    public Optional<CqlFilter> getFilter();

    @Value.Default
    default public int getAttributesPosition() {
        return 0;
    }

    @Value.Default
    default public String getIdField() {
        return this.getAttributes().stream().filter(FeatureStoreAttribute::isId).map(FeatureStoreAttribute::getName).findFirst().orElse(this.getSortKey());
    }

    public List<FeatureStoreRelatedContainer> getRelatedContainers();

    @Value.Derived
    @Value.Auxiliary
    default public List<FeatureStoreAttributesContainer> getAllAttributesContainers() {
        return ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)new ImmutableList.Builder().addAll(this.getRelatedContainers().subList(0, this.getAttributesPosition()))).add(this)).addAll(this.getRelatedContainers().subList(this.getAttributesPosition(), this.getRelatedContainers().size()))).build();
    }

    @Override
    @Value.Derived
    default public String getInstanceContainerName() {
        return this.getName();
    }

    @Value.Derived
    @Value.Auxiliary
    default public List<String> getMultiContainerNames() {
        return this.getRelatedContainers().stream().flatMap(relatedContainer -> relatedContainer.getInstanceConnection().stream()).filter(relation -> relation.isOne2N() || relation.isM2N()).map(featureStoreRelation -> String.format("[%s=%s]%s", featureStoreRelation.getJunctionTarget().orElse(featureStoreRelation.getSourceField()), featureStoreRelation.getTargetField(), featureStoreRelation.getTargetContainer())).distinct().collect(ImmutableList.toImmutableList());
    }

    @Value.Derived
    @Value.Auxiliary
    default public Optional<FeatureStoreAttributesContainer> getSpatialAttributesContainer() {
        return this.getAllAttributesContainers().stream().filter(FeatureStoreAttributesContainer::isSpatial).findFirst();
    }

    @Value.Derived
    @Value.Auxiliary
    default public Optional<FeatureStoreAttributesContainer> getTemporalAttributesContainer(String property) {
        return this.getAllAttributesContainers().stream().filter(c -> c.isTemporal(property)).findFirst();
    }

    @Value.Derived
    @Value.Auxiliary
    default public Optional<FeatureStoreAttributesContainer> getMainAttributesContainer() {
        return this.getAllAttributesContainers().stream().filter(FeatureStoreAttributesContainer::isMain).findFirst();
    }
}

