/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.domain;

import de.ii.xtraplatform.features.domain.FeatureStoreAttribute;
import java.util.List;
import java.util.Optional;
import shadow.com.google.common.base.Joiner;
import shadow.com.google.common.collect.ImmutableList;
import shadow.org.immutables.value.Value;

public interface FeatureStoreAttributesContainer {
    public String getName();

    public List<String> getPath();

    public String getSortKey();

    public String getInstanceContainerName();

    public List<FeatureStoreAttribute> getAttributes();

    @Value.Derived
    @Value.Auxiliary
    default public String getPathString() {
        return "/" + Joiner.on('/').join(this.getPath());
    }

    @Value.Derived
    @Value.Auxiliary
    default public List<List<String>> getAttributePaths() {
        return this.getAttributes().stream().map(FeatureStoreAttribute::getPath).collect(ImmutableList.toImmutableList());
    }

    @Value.Derived
    @Value.Auxiliary
    default public List<String> getSortKeys() {
        return ImmutableList.of(String.format("%s.%s", this.getName(), this.getSortKey()));
    }

    @Value.Derived
    @Value.Auxiliary
    default public boolean isSpatial() {
        return this.getAttributes().stream().anyMatch(FeatureStoreAttribute::isSpatial);
    }

    @Value.Derived
    @Value.Auxiliary
    default public Optional<FeatureStoreAttribute> getSpatialAttribute() {
        return this.getAttributes().stream().filter(FeatureStoreAttribute::isSpatial).findFirst();
    }

    @Value.Derived
    @Value.Auxiliary
    default public boolean isTemporal(String property) {
        return this.getAttributes().stream().filter(p -> p.getQueryable().equals(property)).anyMatch(FeatureStoreAttribute::isTemporal);
    }

    @Value.Derived
    @Value.Auxiliary
    default public Optional<FeatureStoreAttribute> getTemporalAttribute(String property) {
        return this.getAttributes().stream().filter(FeatureStoreAttribute::isTemporal).filter(p -> p.getQueryable().equals(property)).findFirst();
    }

    @Value.Derived
    @Value.Auxiliary
    default public boolean isMain() {
        return this.getAttributes().stream().anyMatch(FeatureStoreAttribute::isId);
    }

    @Value.Derived
    @Value.Auxiliary
    default public Optional<FeatureStoreAttribute> getIdAttribute() {
        return this.getAttributes().stream().filter(FeatureStoreAttribute::isId).findFirst();
    }
}

