/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.domain;

import de.ii.xtraplatform.features.domain.ImmutableFeatureSchema;
import de.ii.xtraplatform.features.domain.SchemaBase;
import de.ii.xtraplatform.features.domain.SchemaConstraints;
import de.ii.xtraplatform.features.domain.Tuple;
import de.ii.xtraplatform.features.domain.transform.ImmutablePropertyTransformation;
import de.ii.xtraplatform.features.domain.transform.PropertyTransformation;
import de.ii.xtraplatform.geometries.domain.SimpleFeatureGeometry;
import de.ii.xtraplatform.store.domain.entities.maptobuilder.Buildable;
import de.ii.xtraplatform.store.domain.entities.maptobuilder.BuildableBuilder;
import de.ii.xtraplatform.store.domain.entities.maptobuilder.BuildableMap;
import de.ii.xtraplatform.store.domain.entities.maptobuilder.encoding.BuildableMapEncodingEnabled;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadow.com.fasterxml.jackson.annotation.JsonAlias;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.annotation.JsonMerge;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import shadow.com.fasterxml.jackson.annotation.OptBoolean;
import shadow.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.common.collect.ImmutableMap;
import shadow.org.immutables.value.Value;

@JsonDeserialize(builder=ImmutableFeatureSchema.Builder.class)
@JsonPropertyOrder(value={"sourcePath", "type", "role", "valueType", "geometryType", "objectType", "label", "description", "transformations", "constraints", "properties"})
@Value.Immutable
@Value.Style(deepImmutablesDetection=true, builder="new", attributeBuilderDetection=true)
@BuildableMapEncodingEnabled
public interface FeatureSchema
extends SchemaBase<FeatureSchema>,
Buildable<FeatureSchema> {
    public static final Logger LOGGER = LoggerFactory.getLogger(FeatureSchema.class);

    @Override
    @JsonIgnore
    public String getName();

    @Override
    @JsonIgnore
    public List<String> getPath();

    @Override
    @JsonIgnore
    public List<String> getParentPath();

    @Override
    @JsonAlias(value={"path"})
    public Optional<String> getSourcePath();

    @Override
    @JsonMerge(value=OptBoolean.FALSE)
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    public List<String> getSourcePaths();

    @Override
    @Value.Default
    default public SchemaBase.Type getType() {
        return this.getPropertyMap().isEmpty() ? SchemaBase.Type.STRING : SchemaBase.Type.OBJECT;
    }

    @Override
    public Optional<SchemaBase.Role> getRole();

    @Override
    public Optional<SchemaBase.Type> getValueType();

    @Override
    public Optional<SimpleFeatureGeometry> getGeometryType();

    public Optional<String> getObjectType();

    public Optional<String> getLabel();

    public Optional<String> getDescription();

    public Optional<String> getConstantValue();

    public List<PropertyTransformation> getTransformations();

    @Override
    public Optional<SchemaConstraints> getConstraints();

    @Override
    public Optional<Boolean> getForcePolygonCCW();

    @JsonProperty(value="properties")
    public BuildableMap<FeatureSchema, ImmutableFeatureSchema.Builder> getPropertyMap();

    default public ImmutableFeatureSchema.Builder getBuilder() {
        return new ImmutableFeatureSchema.Builder().from(this);
    }

    public Map<String, String> getAdditionalInfo();

    @Override
    @JsonIgnore
    @Value.Derived
    @Value.Auxiliary
    default public List<FeatureSchema> getProperties() {
        return this.getPropertyMap().values().stream().map(featureSchema -> {
            ImmutableFeatureSchema.Builder builder = new ImmutableFeatureSchema.Builder().from((FeatureSchema)featureSchema);
            if (this.getFullPath().size() > featureSchema.getParentPath().size()) {
                builder.parentPath(this.getFullPath());
            }
            if (featureSchema.getPath().isEmpty()) {
                builder.addPath(featureSchema.getName());
            }
            return builder.build();
        }).collect(Collectors.toList());
    }

    @Override
    @JsonIgnore
    @Value.Derived
    @Value.Auxiliary
    default public boolean isFeature() {
        return this.isObject() && !this.getEffectiveSourcePaths().isEmpty() && this.getEffectiveSourcePaths().get(0).startsWith("/");
    }

    @JsonIgnore
    @Value.Derived
    @Value.Auxiliary
    default public boolean isConstant() {
        return this.isValue() && this.getConstantValue().isPresent() || this.isObject() && this.getProperties().stream().allMatch(FeatureSchema::isConstant);
    }

    @Value.Check
    default public FeatureSchema normalizeConstants() {
        if (!this.getPropertyMap().isEmpty() && this.getPropertyMap().values().stream().anyMatch(property -> property.getConstantValue().isPresent() && property.getSourcePaths().isEmpty())) {
            int[] constantCounter = new int[]{0};
            Map properties = this.getPropertyMap().entrySet().stream().map(entry -> {
                if (((FeatureSchema)entry.getValue()).getConstantValue().isPresent() && !((FeatureSchema)entry.getValue()).getSourcePath().isPresent()) {
                    String constantValue = ((FeatureSchema)entry.getValue()).getType() == SchemaBase.Type.STRING ? String.format("'%s'", ((FeatureSchema)entry.getValue()).getConstantValue().get()) : ((FeatureSchema)entry.getValue()).getConstantValue().get();
                    Object[] objectArray = new Object[3];
                    objectArray[0] = this.getName();
                    int n = constantCounter[0];
                    constantCounter[0] = n + 1;
                    objectArray[1] = n;
                    objectArray[2] = constantValue;
                    String constantSourcePath = String.format("constant_%s_%d{constant=%s}", objectArray);
                    return new AbstractMap.SimpleEntry<String, ImmutableFeatureSchema>((String)entry.getKey(), new ImmutableFeatureSchema.Builder().from((FeatureSchema)entry.getValue()).addSourcePaths(constantSourcePath).build());
                }
                return entry;
            }).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
            return new ImmutableFeatureSchema.Builder().from(this).propertyMap(properties).build();
        }
        return this;
    }

    @Value.Check
    default public FeatureSchema backwardsCompatibility() {
        if (!this.getParentPath().isEmpty() && !this.getParentPath().get(0).contains(":") && this.getSourcePath().filter(path -> path.lastIndexOf(58) > path.lastIndexOf(47)).isPresent()) {
            String path1 = this.getSourcePath().get().substring(0, this.getSourcePath().get().lastIndexOf(58));
            String path2 = path1.substring(0, path1.lastIndexOf(47) + 1) + this.getSourcePath().get().substring(this.getSourcePath().get().lastIndexOf(58) + 1);
            LOGGER.info("The sourcePath '{}' in property '{}' uses a deprecated style that includes a colon to merge two columns. Please use multiple sourcePaths instead, one for each column.", (Object)this.getSourcePath().get(), (Object)this.getName());
            return new ImmutableFeatureSchema.Builder().from(this).sourcePath(Optional.empty()).sourcePaths(ImmutableList.of(path1, path2)).addTransformations((PropertyTransformation)new ImmutablePropertyTransformation.Builder().stringFormat(String.format("{{%s}} ||| {{%s}}", path1, path2)).build()).build();
        }
        return this;
    }

    @Value.Check
    default public FeatureSchema primaryGeometry() {
        if (this.isFeature() && this.getPrimaryGeometry().isPresent() && this.getPrimaryGeometry().filter(SchemaBase::isPrimaryGeometry).isEmpty()) {
            FeatureSchema primaryGeometry = (FeatureSchema)this.getPrimaryGeometry().get();
            ImmutableFeatureSchema.Builder builder = new ImmutableFeatureSchema.Builder().from(this).propertyMap(new HashMap<String, FeatureSchema>());
            this.getPropertyMap().forEach((name, property) -> {
                if (property.isSpatial() && Objects.equals(property.getName(), primaryGeometry.getName())) {
                    builder.putPropertyMap((String)name, new ImmutableFeatureSchema.Builder().from((FeatureSchema)property).role(SchemaBase.Role.PRIMARY_GEOMETRY).build());
                } else {
                    builder.putPropertyMap((String)name, (FeatureSchema)property);
                }
            });
            return builder.build();
        }
        return this;
    }

    @Value.Check
    default public FeatureSchema primaryInstant() {
        if (this.isFeature() && this.getPrimaryInstant().isPresent() && this.getPrimaryInstant().filter(SchemaBase::isPrimaryInstant).isEmpty()) {
            FeatureSchema primaryInstant = (FeatureSchema)this.getPrimaryInstant().get();
            ImmutableFeatureSchema.Builder builder = new ImmutableFeatureSchema.Builder().from(this).propertyMap(new HashMap<String, FeatureSchema>());
            this.getPropertyMap().forEach((name, property) -> {
                if (property.isTemporal() && Objects.equals(property.getName(), primaryInstant.getName())) {
                    builder.putPropertyMap((String)name, new ImmutableFeatureSchema.Builder().from((FeatureSchema)property).role(SchemaBase.Role.PRIMARY_INSTANT).build());
                } else {
                    builder.putPropertyMap((String)name, (FeatureSchema)property);
                }
            });
            return builder.build();
        }
        return this;
    }

    @Value.Check
    default public FeatureSchema primaryInterval() {
        if (this.isFeature() && this.getPrimaryInterval().isPresent() && this.getPrimaryInterval().filter(interval -> ((FeatureSchema)interval.first()).isPrimaryIntervalStart() && ((FeatureSchema)interval.second()).isPrimaryIntervalEnd()).isEmpty()) {
            Tuple primaryInterval = this.getPrimaryInterval().get();
            ImmutableFeatureSchema.Builder builder = new ImmutableFeatureSchema.Builder().from(this).propertyMap(new HashMap<String, FeatureSchema>());
            this.getPropertyMap().forEach((name, property) -> {
                if (property.isTemporal() && Objects.equals(property.getName(), ((FeatureSchema)primaryInterval.first()).getName())) {
                    builder.putPropertyMap((String)name, new ImmutableFeatureSchema.Builder().from((FeatureSchema)property).role(SchemaBase.Role.PRIMARY_INTERVAL_START).build());
                } else if (property.isTemporal() && Objects.equals(property.getName(), ((FeatureSchema)primaryInterval.second()).getName())) {
                    builder.putPropertyMap((String)name, new ImmutableFeatureSchema.Builder().from((FeatureSchema)property).role(SchemaBase.Role.PRIMARY_INTERVAL_END).build());
                } else {
                    builder.putPropertyMap((String)name, (FeatureSchema)property);
                }
            });
            return builder.build();
        }
        return this;
    }

    public static abstract class Builder
    implements BuildableBuilder<FeatureSchema> {
        public abstract ImmutableFeatureSchema.Builder putPropertyMap(String var1, ImmutableFeatureSchema.Builder var2);

        @JsonProperty(value="properties")
        public ImmutableFeatureSchema.Builder putProperties2(Map<String, ImmutableFeatureSchema.Builder> builderMap) {
            ImmutableFeatureSchema.Builder builder1 = null;
            for (Map.Entry<String, ImmutableFeatureSchema.Builder> entry : builderMap.entrySet()) {
                String key = entry.getKey();
                ImmutableFeatureSchema.Builder builder = entry.getValue();
                builder1 = this.putPropertyMap(key, builder.name(key));
            }
            return builder1;
        }

        public ImmutableFeatureSchema.Builder putProperties2(String key, ImmutableFeatureSchema.Builder builder) {
            return this.putPropertyMap(key, builder.name(key));
        }
    }
}

