/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.domain;

import de.ii.xtraplatform.crs.domain.EpsgCrs;
import de.ii.xtraplatform.features.domain.ApplyKeyToValueMap;
import de.ii.xtraplatform.features.domain.ExtendableConfiguration;
import de.ii.xtraplatform.features.domain.ExtensionConfiguration;
import de.ii.xtraplatform.features.domain.FeatureSchema;
import de.ii.xtraplatform.features.domain.ImmutableFeatureProviderCommonData;
import de.ii.xtraplatform.features.domain.ImmutableFeatureSchema;
import de.ii.xtraplatform.features.domain.ZoneIdFromString;
import de.ii.xtraplatform.store.domain.entities.AutoEntity;
import de.ii.xtraplatform.store.domain.entities.EntityData;
import de.ii.xtraplatform.store.domain.entities.EntityDataBuilder;
import de.ii.xtraplatform.store.domain.entities.ValidationResult;
import de.ii.xtraplatform.store.domain.entities.maptobuilder.BuildableMap;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.annotation.JsonMerge;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.org.immutables.value.Value;

@JsonDeserialize(builder=ImmutableFeatureProviderCommonData.Builder.class)
public interface FeatureProviderDataV2
extends EntityData,
AutoEntity,
ExtendableConfiguration {
    @Override
    @Value.Derived
    default public long getEntitySchemaVersion() {
        return 2L;
    }

    public String getProviderType();

    public String getFeatureProviderType();

    @Override
    @Value.Derived
    default public Optional<String> getEntitySubType() {
        return Optional.of(String.format("%s/%s", this.getProviderType(), this.getFeatureProviderType()).toLowerCase());
    }

    public Optional<EpsgCrs> getNativeCrs();

    @JsonDeserialize(converter=ZoneIdFromString.class)
    public Optional<ZoneId> getNativeTimeZone();

    public Optional<String> getDefaultLanguage();

    @Value.Default
    default public ValidationResult.MODE getTypeValidation() {
        return ValidationResult.MODE.NONE;
    }

    @Override
    public List<ExtensionConfiguration> getExtensions();

    @JsonMerge
    public BuildableMap<FeatureSchema, ImmutableFeatureSchema.Builder> getTypes();

    public Map<String, Map<String, String>> getCodelists();

    public List<String> getAutoTypes();

    public static abstract class Builder<T extends Builder<T>>
    implements EntityDataBuilder<FeatureProviderDataV2> {
        @JsonIgnore
        public abstract Map<String, ImmutableFeatureSchema.Builder> getTypes();

        @JsonProperty(value="types")
        public Map<String, ImmutableFeatureSchema.Builder> getTypes2() {
            Map<String, ImmutableFeatureSchema.Builder> types = this.getTypes();
            return new ApplyKeyToValueMap<ImmutableFeatureSchema.Builder>(types, (key, builder) -> builder.name((String)key));
        }

        public abstract T putTypes(String var1, ImmutableFeatureSchema.Builder var2);

        @JsonProperty(value="types")
        public T putTypes2(String key, ImmutableFeatureSchema.Builder builder) {
            return this.putTypes(key, builder.name(key));
        }

        public abstract T id(String var1);

        public abstract T providerType(String var1);

        public abstract T featureProviderType(String var1);

        @JsonIgnore
        public abstract T extensions(Iterable<? extends ExtensionConfiguration> var1);

        @JsonProperty(value="extensions")
        public abstract T addAllExtensions(Iterable<? extends ExtensionConfiguration> var1);
    }
}

