/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.domain;

import de.ii.xtraplatform.features.domain.ImmutableFeatureProperty;
import de.ii.xtraplatform.store.domain.entities.maptobuilder.Buildable;
import de.ii.xtraplatform.store.domain.entities.maptobuilder.BuildableBuilder;
import java.util.Map;
import java.util.Optional;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.org.immutables.value.Value;

@JsonDeserialize(builder=ImmutableFeatureProperty.Builder.class)
@Value.Immutable
@Value.Style(deepImmutablesDetection=true, builder="new", attributeBuilderDetection=true)
public interface FeatureProperty
extends Buildable<FeatureProperty> {
    default public ImmutableFeatureProperty.Builder getBuilder() {
        return new ImmutableFeatureProperty.Builder().from(this);
    }

    @JsonIgnore
    public String getName();

    public String getPath();

    @Value.Default
    default public Type getType() {
        return Type.STRING;
    }

    public Optional<Role> getRole();

    public Optional<String> getConstantValue();

    public Map<String, String> getAdditionalInfo();

    @JsonIgnore
    @Value.Derived
    @Value.Auxiliary
    default public boolean isId() {
        return this.getRole().filter(role -> role == Role.ID).isPresent();
    }

    @JsonIgnore
    @Value.Derived
    @Value.Auxiliary
    default public boolean isType() {
        return this.getRole().filter(role -> role == Role.TYPE).isPresent();
    }

    @JsonIgnore
    @Value.Derived
    @Value.Auxiliary
    default public boolean isSpatial() {
        return this.getType() == Type.GEOMETRY;
    }

    @JsonIgnore
    @Value.Derived
    @Value.Auxiliary
    default public boolean isTemporal() {
        return this.getType() == Type.DATETIME;
    }

    @JsonIgnore
    @Value.Derived
    @Value.Auxiliary
    default public boolean isReference() {
        return false;
    }

    @JsonIgnore
    @Value.Derived
    @Value.Auxiliary
    default public boolean isReferenceEmbed() {
        return false;
    }

    @JsonIgnore
    @Value.Derived
    @Value.Auxiliary
    default public boolean isForceReversePolygon() {
        return false;
    }

    @Deprecated
    @JsonIgnore
    @Value.Derived
    @Value.Auxiliary
    default public boolean hasDoubleColumn() {
        return this.getPath().indexOf(":") > this.getPath().lastIndexOf("/");
    }

    public static abstract class Builder
    implements BuildableBuilder<FeatureProperty> {
    }

    public static enum Type {
        INTEGER,
        FLOAT,
        STRING,
        BOOLEAN,
        DATETIME,
        DATE,
        GEOMETRY,
        OBJECT,
        VALUE_ARRAY,
        OBJECT_ARRAY,
        UNKNOWN;

    }

    public static enum Role {
        ID,
        TYPE,
        PRIMARY_GEOMETRY,
        PRIMARY_INSTANT,
        PRIMARY_INTERVAL_START,
        PRIMARY_INTERVAL_END;

    }
}

