/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.domain;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import shadow.com.google.common.base.Joiner;
import shadow.com.google.common.collect.ImmutableList;

public class FeaturePathTracker {
    private static final Joiner DEFAULT_JOINER = Joiner.on('.').skipNulls();
    private final Joiner joiner;
    private final List<String> localPath = new ArrayList<String>(64);

    public FeaturePathTracker() {
        this.joiner = DEFAULT_JOINER;
    }

    public FeaturePathTracker(String separator) {
        this.joiner = Joiner.on(separator).skipNulls();
    }

    public void track(int depth) {
        this.shorten(depth);
    }

    public void track(String localName, int depth) {
        if (depth < 0) {
            return;
        }
        this.shorten(depth);
        this.track(localName);
    }

    private void shorten(int depth) {
        if (depth < 0) {
            return;
        }
        if (depth < this.localPath.size()) {
            this.localPath.subList(depth, this.localPath.size()).clear();
        }
    }

    public void track(String localName) {
        this.localPath.add(localName);
    }

    public void track(List<String> path) {
        this.localPath.clear();
        this.localPath.addAll(path);
    }

    public String toString() {
        if (this.localPath.isEmpty()) {
            return "";
        }
        return this.joiner.join(this.localPath);
    }

    public String toStringWithDefaultSeparator() {
        if (this.localPath.isEmpty()) {
            return "";
        }
        return DEFAULT_JOINER.join(this.localPath);
    }

    public List<String> asList() {
        if (this.localPath.isEmpty()) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf(this.localPath);
    }

    public boolean containedIn(List<String> path) {
        if (path.size() < this.localPath.size()) {
            return false;
        }
        return Objects.equals(path.subList(0, this.localPath.size()), this.localPath);
    }
}

