/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.domain;

import de.ii.xtraplatform.features.domain.FeatureBase;
import de.ii.xtraplatform.features.domain.FeatureEventHandler;
import de.ii.xtraplatform.features.domain.FeatureTokenTransformerBase;
import de.ii.xtraplatform.features.domain.PropertyBase;
import de.ii.xtraplatform.features.domain.SchemaBase;
import de.ii.xtraplatform.features.domain.SchemaMappingBase;
import de.ii.xtraplatform.geometries.domain.SimpleFeatureGeometry;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import shadow.com.google.common.collect.ImmutableMap;

public abstract class FeatureObjectTransformerBase<T extends SchemaBase<T>, U extends SchemaMappingBase<T>, V extends PropertyBase<V, T>, W extends FeatureBase<V, T>>
extends FeatureTokenTransformerBase<T, U, FeatureEventHandler.ModifiableContext<T, U>> {
    private W currentFeature;
    private V currentObjectOrArray;

    public abstract W createFeature();

    public abstract V createProperty();

    public abstract void onFeature(W var1);

    @Override
    public void onStart(FeatureEventHandler.ModifiableContext<T, U> context) {
    }

    @Override
    public void onEnd(FeatureEventHandler.ModifiableContext<T, U> context) {
    }

    @Override
    public final void onFeatureStart(FeatureEventHandler.ModifiableContext<T, U> context) {
        if (context.schema().isEmpty()) {
            return;
        }
        this.currentFeature = this.createFeature();
        this.currentFeature.schema((SchemaBase)((SchemaBase)context.schema().get()));
        this.currentFeature.collectionMetadata(context.metadata());
        this.currentObjectOrArray = null;
    }

    @Override
    public final void onFeatureEnd(FeatureEventHandler.ModifiableContext<T, U> context) {
        this.onFeature(this.currentFeature);
        this.currentFeature = null;
        this.currentObjectOrArray = null;
    }

    @Override
    public final void onObjectStart(FeatureEventHandler.ModifiableContext<T, U> context) {
        if (context.schema().isEmpty()) {
            return;
        }
        this.currentObjectOrArray = this.createProperty(PropertyBase.Type.OBJECT, context.path(), (SchemaBase)context.schema().get(), context.geometryType().orElse(null));
    }

    @Override
    public final void onObjectEnd(FeatureEventHandler.ModifiableContext<T, U> context) {
        this.currentObjectOrArray = this.getCurrentParent();
    }

    @Override
    public final void onArrayStart(FeatureEventHandler.ModifiableContext<T, U> context) {
        if (context.schema().isEmpty()) {
            return;
        }
        this.currentObjectOrArray = this.createProperty(PropertyBase.Type.ARRAY, context.path(), (SchemaBase)context.schema().get());
    }

    @Override
    public final void onArrayEnd(FeatureEventHandler.ModifiableContext<T, U> context) {
        this.currentObjectOrArray = this.getCurrentParent();
    }

    @Override
    public final void onValue(FeatureEventHandler.ModifiableContext<T, U> context) {
        if (context.schema().isEmpty() || Objects.isNull(context.value())) {
            return;
        }
        this.createProperty(PropertyBase.Type.VALUE, context.path(), (SchemaBase)context.schema().get(), context.value(), context.transformed());
    }

    private V createProperty(PropertyBase.Type type, List<String> path, T schema) {
        return this.createProperty(type, path, schema, null, null, ImmutableMap.of());
    }

    private V createProperty(PropertyBase.Type type, List<String> path, T schema, SimpleFeatureGeometry geometryType) {
        return this.createProperty(type, path, schema, null, geometryType, ImmutableMap.of());
    }

    private V createProperty(PropertyBase.Type type, List<String> path, T schema, String value, Map<String, String> transformed) {
        return this.createProperty(type, path, schema, value, null, transformed);
    }

    private V createProperty(PropertyBase.Type type, List<String> path, T schema, String value, SimpleFeatureGeometry geometryType, Map<String, String> transformed) {
        V property = this.createProperty();
        property.type(type).schema(schema).propertyPath(path).value(value).geometryType(Optional.ofNullable(geometryType)).transformed(transformed);
        if (Objects.nonNull(this.currentObjectOrArray)) {
            property.parent(this.currentObjectOrArray);
            this.currentObjectOrArray.addNestedProperties(property);
        } else {
            this.currentFeature.addProperties(property);
        }
        return property;
    }

    private V getCurrentParent() {
        return (V)(Objects.nonNull(this.currentObjectOrArray) && this.currentObjectOrArray.getParent().isPresent() ? (PropertyBase)this.currentObjectOrArray.getParent().get() : null);
    }
}

