/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.domain;

import de.ii.xtraplatform.features.domain.FeaturePathTracker;
import de.ii.xtraplatform.features.domain.FeatureQuery;
import de.ii.xtraplatform.features.domain.ModifiableCollectionMetadata;
import de.ii.xtraplatform.features.domain.SchemaBase;
import de.ii.xtraplatform.features.domain.SchemaMappingBase;
import de.ii.xtraplatform.geometries.domain.SimpleFeatureGeometry;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import shadow.com.google.common.collect.ImmutableList;
import shadow.javax.annotation.Nullable;
import shadow.org.immutables.value.Value;

public interface FeatureEventHandler<T extends SchemaBase<T>, U extends SchemaMappingBase<T>, V extends ModifiableContext<T, U>> {
    public void onStart(V var1);

    public void onEnd(V var1);

    public void onFeatureStart(V var1);

    public void onFeatureEnd(V var1);

    public void onObjectStart(V var1);

    public void onObjectEnd(V var1);

    public void onArrayStart(V var1);

    public void onArrayEnd(V var1);

    public void onValue(V var1);

    public static interface ModifiableContext<T extends SchemaBase<T>, U extends SchemaMappingBase<T>>
    extends Context<T, U> {
        @Override
        @Value.Default
        default public ModifiableCollectionMetadata metadata() {
            ModifiableCollectionMetadata collectionMetadata = ModifiableCollectionMetadata.create();
            this.setMetadata(collectionMetadata);
            return collectionMetadata;
        }

        @Value.Default
        default public FeaturePathTracker pathTracker() {
            Optional pathSeparator = Optional.ofNullable(this.mapping()).flatMap(u -> u.getPathSeparator());
            FeaturePathTracker pathTracker = pathSeparator.isPresent() ? new FeaturePathTracker((String)pathSeparator.get()) : new FeaturePathTracker();
            this.setPathTracker(pathTracker);
            return pathTracker;
        }

        @Override
        @Value.Lazy
        default public List<String> path() {
            return this.pathTracker().asList();
        }

        @Override
        @Value.Lazy
        default public String pathAsString() {
            return this.pathTracker().toStringWithDefaultSeparator();
        }

        @Value.Lazy
        default public boolean shouldSkip() {
            return this.isBuffering() || this.currentSchema().isEmpty() || !this.shouldInclude((SchemaBase)this.currentSchema().get(), this.parentSchemas(), this.pathTracker().toString());
        }

        private boolean shouldInclude(T schema, List<T> parentSchemas, String path) {
            return schema.isId() || schema.isSpatial() && !this.query().skipGeometry() || !schema.isId() && !schema.isSpatial() && this.propertyIsInFields(path);
        }

        default public boolean propertyIsInFields(String property) {
            return this.query().getFields().isEmpty() || this.query().getFields().contains("*") || this.query().getFields().stream().anyMatch(field -> field.startsWith(property));
        }

        default public boolean isRequired(T schema, List<T> parentSchemas) {
            return schema.isRequired() && (parentSchemas.size() <= 1 || parentSchemas.stream().limit(parentSchemas.size() - 1).allMatch(SchemaBase::isRequired));
        }

        public ModifiableContext<T, U> setMetadata(ModifiableCollectionMetadata var1);

        public ModifiableContext<T, U> setPathTracker(FeaturePathTracker var1);

        public ModifiableContext<T, U> setGeometryType(SimpleFeatureGeometry var1);

        public ModifiableContext<T, U> setGeometryType(Optional<SimpleFeatureGeometry> var1);

        public ModifiableContext<T, U> setGeometryDimension(int var1);

        public ModifiableContext<T, U> setGeometryDimension(OptionalInt var1);

        public ModifiableContext<T, U> setValue(String var1);

        public ModifiableContext<T, U> setValueType(SchemaBase.Type var1);

        public ModifiableContext<T, U> putValueBuffer(String var1, String var2);

        public ModifiableContext<T, U> setCustomSchema(T var1);

        public ModifiableContext<T, U> setInGeometry(boolean var1);

        public ModifiableContext<T, U> setInObject(boolean var1);

        public ModifiableContext<T, U> setInArray(boolean var1);

        public ModifiableContext<T, U> setIndexes(Iterable<Integer> var1);

        public ModifiableContext<T, U> setQuery(FeatureQuery var1);

        public ModifiableContext<T, U> setMapping(U var1);

        public ModifiableContext<T, U> setSchemaIndex(int var1);

        public ModifiableContext<T, U> putTransformed(String var1, String var2);

        public ModifiableContext<T, U> setIsBuffering(boolean var1);

        public ModifiableContext<T, U> putAdditionalInfo(String var1, String var2);
    }

    public static interface Context<T extends SchemaBase<T>, U extends SchemaMappingBase<T>> {
        public ModifiableCollectionMetadata metadata();

        public List<String> path();

        public String pathAsString();

        public Optional<SimpleFeatureGeometry> geometryType();

        public OptionalInt geometryDimension();

        @Nullable
        public String value();

        @Nullable
        public SchemaBase.Type valueType();

        public Map<String, String> valueBuffer();

        @Nullable
        public T customSchema();

        @Value.Default
        default public boolean inGeometry() {
            return false;
        }

        @Value.Default
        default public boolean inObject() {
            return false;
        }

        @Value.Default
        default public boolean inArray() {
            return false;
        }

        public List<Integer> indexes();

        @Value.Lazy
        default public long index() {
            return this.indexes().isEmpty() ? 0L : (long)this.indexes().get(this.indexes().size() - 1).intValue();
        }

        public FeatureQuery query();

        public U mapping();

        @Value.Default
        default public int schemaIndex() {
            return -1;
        }

        public Map<String, String> transformed();

        @Value.Default
        default public boolean isBuffering() {
            return false;
        }

        public Map<String, String> additionalInfo();

        @Value.Lazy
        default public Optional<T> schema() {
            return Optional.ofNullable(this.customSchema()).or(this::currentSchema);
        }

        @Value.Lazy
        default public Optional<T> currentSchema() {
            List<String> path = this.path();
            if (path.isEmpty()) {
                return Optional.ofNullable(this.mapping().getTargetSchema());
            }
            List targetSchemas = this.mapping().getTargetSchemas(path);
            if (targetSchemas.isEmpty()) {
                if (this.inGeometry()) {
                    return this.mapping().getTargetSchema().getPrimaryGeometry();
                }
                return Optional.empty();
            }
            int schemaIndex = this.schemaIndex() > -1 ? this.schemaIndex() : targetSchemas.size() - 1;
            SchemaBase targetSchema = (SchemaBase)targetSchemas.get(schemaIndex);
            return Optional.ofNullable(targetSchema);
        }

        @Value.Lazy
        default public List<T> parentSchemas() {
            List<String> path = this.path();
            if (path.isEmpty()) {
                return ImmutableList.of();
            }
            List parentSchemas = this.mapping().getParentSchemas(path);
            if (parentSchemas.isEmpty()) {
                return ImmutableList.of();
            }
            int schemaIndex = this.schemaIndex() > -1 ? this.schemaIndex() : parentSchemas.size() - 1;
            return parentSchemas.get(schemaIndex);
        }

        @Value.Lazy
        default public boolean isRequired() {
            return this.schema().filter(SchemaBase::isRequired).isPresent();
        }
    }
}

