/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.domain;

import de.ii.xtraplatform.base.domain.LogContext;
import de.ii.xtraplatform.codelists.domain.Codelist;
import de.ii.xtraplatform.crs.domain.CrsTransformer;
import de.ii.xtraplatform.crs.domain.CrsTransformerFactory;
import de.ii.xtraplatform.crs.domain.EpsgCrs;
import de.ii.xtraplatform.crs.domain.OgcCrs;
import de.ii.xtraplatform.features.domain.ConnectionInfo;
import de.ii.xtraplatform.features.domain.ConnectorFactory;
import de.ii.xtraplatform.features.domain.FeatureEventHandler;
import de.ii.xtraplatform.features.domain.FeatureProvider2;
import de.ii.xtraplatform.features.domain.FeatureProviderConnector;
import de.ii.xtraplatform.features.domain.FeatureProviderDataV2;
import de.ii.xtraplatform.features.domain.FeatureQueries;
import de.ii.xtraplatform.features.domain.FeatureQueriesExtension;
import de.ii.xtraplatform.features.domain.FeatureQuery;
import de.ii.xtraplatform.features.domain.FeatureQueryTransformer;
import de.ii.xtraplatform.features.domain.FeatureSchema;
import de.ii.xtraplatform.features.domain.FeatureStoreInstanceContainer;
import de.ii.xtraplatform.features.domain.FeatureStorePathParser;
import de.ii.xtraplatform.features.domain.FeatureStoreTypeInfo;
import de.ii.xtraplatform.features.domain.FeatureStream;
import de.ii.xtraplatform.features.domain.FeatureTokenDecoder;
import de.ii.xtraplatform.features.domain.FeatureTokenSource;
import de.ii.xtraplatform.features.domain.FeatureTokenTransformerLogger;
import de.ii.xtraplatform.features.domain.FeatureTokenTransformerRemoveEmptyOptionals;
import de.ii.xtraplatform.features.domain.FeatureTokenTransformerSchemaMappings;
import de.ii.xtraplatform.features.domain.FeatureTokenTransformerSorting;
import de.ii.xtraplatform.features.domain.FeatureTokenTransformerValueMappings;
import de.ii.xtraplatform.features.domain.ImmutableFeatureStoreTypeInfo;
import de.ii.xtraplatform.features.domain.ImmutableResult;
import de.ii.xtraplatform.features.domain.ImmutableResultReduced;
import de.ii.xtraplatform.features.domain.ProviderExtensionRegistry;
import de.ii.xtraplatform.features.domain.SchemaBase;
import de.ii.xtraplatform.features.domain.SchemaMapping;
import de.ii.xtraplatform.features.domain.TypeInfoValidator;
import de.ii.xtraplatform.features.domain.WithConnectionInfo;
import de.ii.xtraplatform.features.domain.transform.ImmutablePropertyTransformation;
import de.ii.xtraplatform.features.domain.transform.PropertyTransformation;
import de.ii.xtraplatform.features.domain.transform.PropertyTransformations;
import de.ii.xtraplatform.store.domain.entities.AbstractPersistentEntity;
import de.ii.xtraplatform.store.domain.entities.EntityState;
import de.ii.xtraplatform.store.domain.entities.ValidationResult;
import de.ii.xtraplatform.streams.domain.Reactive;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.common.collect.ImmutableMap;

public abstract class AbstractFeatureProvider<T, U, V extends FeatureProviderConnector.QueryOptions>
extends AbstractPersistentEntity<FeatureProviderDataV2>
implements FeatureProvider2,
FeatureQueries {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractFeatureProvider.class);
    private final ConnectorFactory connectorFactory;
    private final Reactive reactive;
    private final CrsTransformerFactory crsTransformerFactory;
    private final ProviderExtensionRegistry extensionRegistry;
    private Reactive.Runner streamRunner;
    private Map<String, FeatureStoreTypeInfo> typeInfos;
    private FeatureProviderConnector<T, U, V> connector;

    protected AbstractFeatureProvider(ConnectorFactory connectorFactory, Reactive reactive, CrsTransformerFactory crsTransformerFactory, ProviderExtensionRegistry extensionRegistry, FeatureProviderDataV2 data) {
        super(data);
        this.connectorFactory = connectorFactory;
        this.reactive = reactive;
        this.crsTransformerFactory = crsTransformerFactory;
        this.extensionRegistry = extensionRegistry;
    }

    private void onConnectorDispose() {
        if (this.getState() != EntityState.STATE.RELOADING) {
            LOGGER.debug("CONNECTOR GONE {}", (Object)this.getId());
            this.doReload();
        }
    }

    @Override
    protected boolean onStartup() throws InterruptedException {
        if (Objects.nonNull(this.connector)) {
            this.connectorFactory.disposeConnector(this.connector);
        }
        if (Objects.nonNull(this.streamRunner)) {
            try {
                this.streamRunner.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.typeInfos = AbstractFeatureProvider.createTypeInfos(this.getPathParser(), ((FeatureProviderDataV2)this.getData()).getTypes());
        this.streamRunner = this.reactive.runner(((FeatureProviderDataV2)this.getData()).getId(), this.getRunnerCapacity((ConnectionInfo)((WithConnectionInfo)this.getData()).getConnectionInfo()), this.getRunnerQueueSize((ConnectionInfo)((WithConnectionInfo)this.getData()).getConnectionInfo()));
        this.connector = this.connectorFactory.createConnector((FeatureProviderDataV2)this.getData());
        this.connectorFactory.onDispose(this.connector, this::onConnectorDispose);
        if (!this.getConnector().isConnected()) {
            this.connectorFactory.disposeConnector(this.connector);
            Optional<Throwable> connectionError = this.getConnector().getConnectionError();
            String message = connectionError.map(Throwable::getMessage).orElse("unknown reason");
            LOGGER.error("Feature provider with id '{}' could not be started: {}", (Object)this.getId(), (Object)message);
            if (connectionError.isPresent() && LOGGER.isDebugEnabled()) {
                LOGGER.debug("Stacktrace:", connectionError.get());
            }
            return false;
        }
        Optional<String> runnerError = this.getRunnerError((ConnectionInfo)((WithConnectionInfo)this.getData()).getConnectionInfo());
        if (runnerError.isPresent()) {
            LOGGER.error("Feature provider with id '{}' could not be started: {}", (Object)this.getId(), (Object)runnerError.get());
            return false;
        }
        if (this.getTypeInfoValidator().isPresent() && ((FeatureProviderDataV2)this.getData()).getTypeValidation() != ValidationResult.MODE.NONE) {
            boolean[] isSuccess = new boolean[]{true};
            try {
                for (FeatureStoreTypeInfo typeInfo : this.getTypeInfos().values()) {
                    LOGGER.info("Validating type '{}' ({})", (Object)typeInfo.getName(), (Object)((FeatureProviderDataV2)this.getData()).getTypeValidation().name().toLowerCase());
                    ValidationResult result = this.getTypeInfoValidator().get().validate(typeInfo, ((FeatureProviderDataV2)this.getData()).getTypeValidation());
                    isSuccess[0] = isSuccess[0] && result.isSuccess();
                    result.getErrors().forEach(LOGGER::error);
                    result.getStrictErrors().forEach(result.getMode() == ValidationResult.MODE.STRICT ? LOGGER::error : LOGGER::warn);
                    result.getWarnings().forEach(LOGGER::warn);
                    this.checkForStartupCancel();
                }
            }
            catch (Throwable e) {
                if (e instanceof InterruptedException) {
                    throw e;
                }
                LogContext.error(LOGGER, e, "Cannot validate types", new Object[0]);
                isSuccess[0] = false;
            }
            if (!isSuccess[0]) {
                LOGGER.error("Feature provider with id '{}' could not be started: {} {}", this.getId(), ((FeatureProviderDataV2)this.getData()).getTypeValidation().name().toLowerCase(), "validation failed");
                return false;
            }
        }
        return true;
    }

    @Override
    protected void onStarted() {
        String startupInfo = this.getStartupInfo().map(map -> String.format(" (%s)", map.toString().replace("{", "").replace("}", ""))).orElse("");
        LOGGER.info("Feature provider with id '{}' started successfully.{}", (Object)this.getId(), (Object)startupInfo);
        this.extensionRegistry.getAll().forEach(extension -> {
            if (extension.isSupported(this.getConnector())) {
                extension.on(FeatureQueriesExtension.LIFECYCLE_HOOK.STARTED, (FeatureProviderDataV2)this.getData(), this.getConnector());
            }
        });
    }

    @Override
    protected void onReloaded() {
        String startupInfo = this.getStartupInfo().map(map -> String.format(" (%s)", map.toString().replace("{", "").replace("}", ""))).orElse("");
        LOGGER.info("Feature provider with id '{}' reloaded successfully.{}", (Object)this.getId(), (Object)startupInfo);
    }

    @Override
    protected void onStopped() {
        this.connectorFactory.disposeConnector(this.connector);
        LOGGER.info("Feature provider with id '{}' stopped.", (Object)this.getId());
    }

    @Override
    protected void onStartupFailure(Throwable throwable) {
        LogContext.error(LOGGER, throwable, "Feature provider with id '{}' could not be started", this.getId());
    }

    protected int getRunnerCapacity(ConnectionInfo connectionInfo) {
        return -1;
    }

    protected int getRunnerQueueSize(ConnectionInfo connectionInfo) {
        return -1;
    }

    protected Optional<String> getRunnerError(ConnectionInfo connectionInfo) {
        return Optional.empty();
    }

    protected abstract FeatureStorePathParser getPathParser();

    protected abstract FeatureQueryTransformer<U, V> getQueryTransformer();

    protected FeatureProviderConnector<T, U, V> getConnector() {
        return Objects.requireNonNull(this.connector);
    }

    protected Map<String, FeatureStoreTypeInfo> getTypeInfos() {
        return this.typeInfos;
    }

    protected Reactive.Runner getStreamRunner() {
        return this.streamRunner;
    }

    protected Optional<Map<String, String>> getStartupInfo() {
        return Optional.empty();
    }

    protected Optional<TypeInfoValidator> getTypeInfoValidator() {
        return Optional.empty();
    }

    protected abstract FeatureTokenDecoder<T, FeatureSchema, SchemaMapping, FeatureEventHandler.ModifiableContext<FeatureSchema, SchemaMapping>> getDecoder(FeatureQuery var1);

    protected abstract Map<String, Codelist> getCodelists();

    public static Map<String, FeatureStoreTypeInfo> createTypeInfos(FeatureStorePathParser pathParser, Map<String, FeatureSchema> featureTypes) {
        return featureTypes.entrySet().stream().map(entry -> {
            List<FeatureStoreInstanceContainer> instanceContainers = pathParser.parse((FeatureSchema)entry.getValue());
            ImmutableFeatureStoreTypeInfo typeInfo = ImmutableFeatureStoreTypeInfo.builder().name((String)entry.getKey()).instanceContainers(instanceContainers).build();
            return new AbstractMap.SimpleImmutableEntry<String, ImmutableFeatureStoreTypeInfo>((String)entry.getKey(), typeInfo);
        }).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public FeatureStream getFeatureStream(final FeatureQuery query) {
        return new FeatureStream(){

            @Override
            public <X> CompletionStage<FeatureStream.ResultReduced<X>> runWith(Reactive.SinkReduced<Object, X> sink, Optional<PropertyTransformations> propertyTransformations) {
                FeatureTokenSource byteSource = this.getFeatureTokenSource(propertyTransformations, ImmutableMap.of());
                Reactive.BasicStream<Object, X> to = byteSource.to(sink);
                Reactive.RunnableStream<FeatureStream.ResultReduced> runnableStream = to.withResult(ImmutableResultReduced.builder().isEmpty(true)).handleError((result, throwable) -> result.error((Throwable)throwable)).handleItem((builder, x) -> ((ImmutableResultReduced.Builder)builder.reduced(x)).isEmpty(false)).handleEnd(FeatureStream.ResultBase.Builder::build).on(AbstractFeatureProvider.this.streamRunner);
                return runnableStream.run();
            }

            @Override
            public CompletionStage<FeatureStream.Result> runWith(Reactive.Sink<Object> sink, Optional<PropertyTransformations> propertyTransformations) {
                FeatureTokenSource byteSource = this.getFeatureTokenSource(propertyTransformations, ImmutableMap.of());
                Reactive.RunnableStream<FeatureStream.Result> runnableStream = byteSource.to(sink).withResult(ImmutableResult.builder().isEmpty(true)).handleError((result, throwable) -> (FeatureStream.Result.Builder)result.error((Throwable)throwable)).handleItem((builder, x) -> (FeatureStream.Result.Builder)builder.isEmpty(false)).handleEnd(FeatureStream.ResultBase.Builder::build).on(AbstractFeatureProvider.this.streamRunner);
                return runnableStream.run();
            }

            @Override
            public CompletionStage<FeatureStream.Result> runWith(Reactive.SinkTransformed<Object, byte[]> sink, Optional<PropertyTransformations> propertyTransformations) {
                HashMap<String, String> virtualTables = new HashMap<String, String>();
                AbstractFeatureProvider.this.extensionRegistry.getAll().forEach(extension -> {
                    if (extension.isSupported(AbstractFeatureProvider.this.getConnector())) {
                        extension.on(FeatureQueriesExtension.QUERY_HOOK.BEFORE, (FeatureProviderDataV2)AbstractFeatureProvider.this.getData(), AbstractFeatureProvider.this.getConnector(), query, virtualTables::put);
                    }
                });
                FeatureTokenSource tokenSource = this.getFeatureTokenSource(propertyTransformations, virtualTables);
                Reactive.RunnableStream<FeatureStream.Result> runnableStream = tokenSource.to(sink).withResult(ImmutableResult.builder().isEmpty(true)).handleError((result, throwable) -> (FeatureStream.Result.Builder)result.error((Throwable)throwable)).handleItem((builder, x) -> (FeatureStream.Result.Builder)builder.isEmpty(false)).handleEnd(FeatureStream.ResultBase.Builder::build).on(AbstractFeatureProvider.this.streamRunner);
                return runnableStream.run().whenComplete((result, throwable) -> AbstractFeatureProvider.this.extensionRegistry.getAll().forEach(extension -> {
                    if (extension.isSupported(AbstractFeatureProvider.this.getConnector())) {
                        extension.on(FeatureQueriesExtension.QUERY_HOOK.AFTER, (FeatureProviderDataV2)AbstractFeatureProvider.this.getData(), AbstractFeatureProvider.this.getConnector(), query, (a, t) -> {});
                    }
                }));
            }

            @Override
            public CompletionStage<FeatureStream.ResultReduced<byte[]>> runWith(Reactive.SinkReducedTransformed<Object, byte[], byte[]> sink, Optional<PropertyTransformations> propertyTransformations) {
                FeatureTokenSource tokenSource = this.getFeatureTokenSource(propertyTransformations, ImmutableMap.of());
                Reactive.RunnableStream<FeatureStream.ResultReduced> runnableStream = tokenSource.to(sink).withResult(((ImmutableResultReduced.Builder)ImmutableResultReduced.builder().reduced(new byte[0])).isEmpty(true)).handleError((result, throwable) -> result.error((Throwable)throwable)).handleItem((builder, bytes) -> ((ImmutableResultReduced.Builder)builder.reduced(bytes)).isEmpty(((byte[])bytes).length > 0)).handleEnd(FeatureStream.ResultBase.Builder::build).on(AbstractFeatureProvider.this.streamRunner);
                return runnableStream.run();
            }

            private FeatureTokenSource getFeatureTokenSource(Optional<PropertyTransformations> propertyTransformations, Map<String, String> virtualTables) {
                Optional<FeatureStoreTypeInfo> typeInfo = Optional.ofNullable(AbstractFeatureProvider.this.getTypeInfos().get(query.getType()));
                if (!typeInfo.isPresent()) {
                    throw new IllegalStateException("No features available for type");
                }
                Object transformedQuery = AbstractFeatureProvider.this.getQueryTransformer().transformQuery(query, virtualTables);
                Object options = AbstractFeatureProvider.this.getQueryTransformer().getOptions(query);
                Reactive.Source source = AbstractFeatureProvider.this.getConnector().getSourceStream(transformedQuery, options);
                FeatureTokenDecoder decoder = AbstractFeatureProvider.this.getDecoder(query);
                FeatureTokenSource featureTokenSource = (FeatureTokenSource)source.via(decoder);
                FeatureSchema featureSchema = (FeatureSchema)((FeatureProviderDataV2)AbstractFeatureProvider.this.getData()).getTypes().get(query.getType());
                Map providerTransformationMap = featureSchema.accept((schema, visitedProperties) -> Stream.concat(schema.getTransformations().isEmpty() ? (schema.isTemporal() ? Stream.of(new AbstractMap.SimpleImmutableEntry<String, ImmutableList<ImmutablePropertyTransformation>>(String.join((CharSequence)".", schema.getFullPath()), ImmutableList.of(new ImmutablePropertyTransformation.Builder().dateFormat(schema.getType() == SchemaBase.Type.DATETIME ? "yyyy-MM-dd'T'HH:mm:ssZZZZZ" : "yyyy-MM-dd").build()))) : Stream.empty()) : Stream.of(new AbstractMap.SimpleImmutableEntry<String, List<PropertyTransformation>>(schema.getFullPath().isEmpty() ? "*" : String.join((CharSequence)".", schema.getFullPath()), schema.getTransformations())), visitedProperties.stream().flatMap(m -> m.entrySet().stream())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue)));
                PropertyTransformations providerTransformations = () -> providerTransformationMap;
                PropertyTransformations mergedTransformations = propertyTransformations.map(p -> p.mergeInto(providerTransformations)).orElse(providerTransformations);
                FeatureTokenTransformerSchemaMappings schemaMapper = new FeatureTokenTransformerSchemaMappings(mergedTransformations);
                Optional<CrsTransformer> crsTransformer = query.getCrs().flatMap(targetCrs -> AbstractFeatureProvider.this.crsTransformerFactory.getTransformer(((FeatureProviderDataV2)AbstractFeatureProvider.this.getData()).getNativeCrs().orElse(OgcCrs.CRS84), (EpsgCrs)targetCrs));
                FeatureTokenTransformerValueMappings valueMapper = new FeatureTokenTransformerValueMappings(mergedTransformations, AbstractFeatureProvider.this.getCodelists(), ((FeatureProviderDataV2)AbstractFeatureProvider.this.getData()).getNativeTimeZone(), crsTransformer);
                FeatureTokenTransformerRemoveEmptyOptionals cleaner = new FeatureTokenTransformerRemoveEmptyOptionals();
                FeatureTokenTransformerSorting sorter = new FeatureTokenTransformerSorting();
                FeatureTokenTransformerLogger logger = new FeatureTokenTransformerLogger();
                return featureTokenSource.via(schemaMapper).via(valueMapper).via(cleaner);
            }
        };
    }

    @Override
    public long getFeatureCount(FeatureQuery featureQuery) {
        return 0L;
    }
}

