/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.feature.transformer.api;

import de.ii.xtraplatform.feature.transformer.api.SimpleFeatureGeometryFrom;
import de.ii.xtraplatform.features.domain.legacy.TargetMapping;
import de.ii.xtraplatform.geometries.domain.SimpleFeatureGeometry;

public interface TargetMappingProviderFromGml {
    public String getTargetType();

    public TargetMapping getTargetMappingForFeatureType(String var1, String var2);

    public TargetMapping getTargetMappingForAttribute(String var1, String var2, String var3, GML_TYPE var4);

    public TargetMapping getTargetMappingForProperty(String var1, String var2, String var3, GML_TYPE var4, boolean var5);

    public TargetMapping getTargetMappingForGeometry(String var1, String var2, String var3, GML_GEOMETRY_TYPE var4);

    public static enum GML_GEOMETRY_TYPE implements SimpleFeatureGeometryFrom
    {
        GEOMETRY("GeometryPropertyType"),
        ABSTRACT_GEOMETRY("GeometricPrimitivePropertyType"),
        POINT("PointPropertyType", "Point"),
        MULTI_POINT("MultiPointPropertyType", "MultiPoint"),
        LINE_STRING("LineStringPropertyType", "LineString"),
        MULTI_LINESTRING("MultiLineStringPropertyType", "MultiLineString"),
        CURVE("CurvePropertyType", "Curve"),
        MULTI_CURVE("MultiCurvePropertyType", "MultiCurve"),
        SURFACE("SurfacePropertyType", "Surface"),
        MULTI_SURFACE("MultiSurfacePropertyType", "MultiSurface"),
        POLYGON("PolygonPropertyType", "Polygon"),
        MULTI_POLYGON("MultiPolygonPropertyType", "MultiPolygon"),
        SOLID("SolidPropertyType"),
        NONE("");

        private String stringRepresentation;
        private String elementStringRepresentation;

        private GML_GEOMETRY_TYPE(String stringRepresentation) {
            this.stringRepresentation = stringRepresentation;
        }

        private GML_GEOMETRY_TYPE(String stringRepresentation, String elementStringRepresentation) {
            this(stringRepresentation);
            this.elementStringRepresentation = elementStringRepresentation;
        }

        public String toString() {
            return this.stringRepresentation;
        }

        public static GML_GEOMETRY_TYPE fromString(String type) {
            for (GML_GEOMETRY_TYPE v : GML_GEOMETRY_TYPE.values()) {
                if (!v.toString().equals(type) && (v.elementStringRepresentation == null || !v.elementStringRepresentation.equals(type))) continue;
                return v;
            }
            return NONE;
        }

        public static boolean contains(String type) {
            for (GML_GEOMETRY_TYPE v : GML_GEOMETRY_TYPE.values()) {
                if (!v.toString().equals(type)) continue;
                return true;
            }
            return false;
        }

        @Override
        public SimpleFeatureGeometry toSimpleFeatureGeometry() {
            SimpleFeatureGeometry simpleFeatureGeometry = SimpleFeatureGeometry.NONE;
            switch (this) {
                case GEOMETRY: 
                case ABSTRACT_GEOMETRY: {
                    simpleFeatureGeometry = SimpleFeatureGeometry.ANY;
                    break;
                }
                case POINT: {
                    simpleFeatureGeometry = SimpleFeatureGeometry.POINT;
                    break;
                }
                case MULTI_POINT: {
                    simpleFeatureGeometry = SimpleFeatureGeometry.MULTI_POINT;
                    break;
                }
                case LINE_STRING: {
                    simpleFeatureGeometry = SimpleFeatureGeometry.LINE_STRING;
                    break;
                }
                case MULTI_LINESTRING: {
                    simpleFeatureGeometry = SimpleFeatureGeometry.MULTI_LINE_STRING;
                    break;
                }
                case CURVE: {
                    simpleFeatureGeometry = SimpleFeatureGeometry.LINE_STRING;
                    break;
                }
                case MULTI_CURVE: {
                    simpleFeatureGeometry = SimpleFeatureGeometry.MULTI_LINE_STRING;
                    break;
                }
                case SURFACE: {
                    simpleFeatureGeometry = SimpleFeatureGeometry.POLYGON;
                    break;
                }
                case MULTI_SURFACE: {
                    simpleFeatureGeometry = SimpleFeatureGeometry.MULTI_POLYGON;
                    break;
                }
                case POLYGON: {
                    simpleFeatureGeometry = SimpleFeatureGeometry.POLYGON;
                    break;
                }
                case MULTI_POLYGON: {
                    simpleFeatureGeometry = SimpleFeatureGeometry.MULTI_POLYGON;
                    break;
                }
            }
            return simpleFeatureGeometry;
        }

        @Override
        public boolean isValid() {
            return this != NONE;
        }
    }

    public static enum GML_TYPE {
        ID("ID"),
        STRING("string"),
        DATE_TIME("dateTime"),
        DATE("date"),
        GEOMETRY("geometry"),
        DECIMAL("decimal"),
        DOUBLE("double"),
        FLOAT("float"),
        INT("int"),
        INTEGER("integer"),
        LONG("long"),
        SHORT("short"),
        BOOLEAN("boolean"),
        URI("anyURI"),
        NONE("");

        private String stringRepresentation;

        private GML_TYPE(String stringRepresentation) {
            this.stringRepresentation = stringRepresentation;
        }

        public String toString() {
            return this.stringRepresentation;
        }

        public static GML_TYPE fromString(String type) {
            for (GML_TYPE v : GML_TYPE.values()) {
                if (!v.toString().equals(type)) continue;
                return v;
            }
            return NONE;
        }

        public static boolean contains(String type) {
            for (GML_TYPE v : GML_TYPE.values()) {
                if (!v.toString().equals(type)) continue;
                return true;
            }
            return false;
        }

        public boolean isValid() {
            return this != NONE;
        }
    }
}

