/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.crs.domain;

import de.ii.xtraplatform.crs.domain.BoundingBox;
import de.ii.xtraplatform.crs.domain.EpsgCrs;
import de.ii.xtraplatform.crs.domain.ImmutableEpsgCrs;
import java.util.ArrayList;
import java.util.Objects;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.common.primitives.Doubles;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="BoundingBox", generator="Immutables")
@Immutable
public final class ImmutableBoundingBox
implements BoundingBox {
    private final double xmin;
    private final double ymin;
    private final double xmax;
    private final double ymax;
    private final ImmutableEpsgCrs epsgCrs;
    private final transient double[] toArray;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableBoundingBox(Builder builder) {
        this.xmin = builder.xmin;
        this.ymin = builder.ymin;
        this.xmax = builder.xmax;
        this.ymax = builder.ymax;
        if (builder.epsgCrs != null) {
            this.initShim.epsgCrs(ImmutableEpsgCrs.copyOf(builder.epsgCrs));
        }
        this.epsgCrs = this.initShim.getEpsgCrs();
        this.toArray = this.initShim.toArray();
        this.initShim = null;
    }

    private ImmutableBoundingBox(double xmin, double ymin, double xmax, double ymax, ImmutableEpsgCrs epsgCrs) {
        this.xmin = xmin;
        this.ymin = ymin;
        this.xmax = xmax;
        this.ymax = ymax;
        this.initShim.epsgCrs(epsgCrs);
        this.epsgCrs = this.initShim.getEpsgCrs();
        this.toArray = this.initShim.toArray();
        this.initShim = null;
    }

    private EpsgCrs getEpsgCrsInitialize() {
        return BoundingBox.super.getEpsgCrs();
    }

    private double[] toArrayInitialize() {
        return BoundingBox.super.toArray();
    }

    @Override
    @JsonProperty(value="xmin")
    public double getXmin() {
        return this.xmin;
    }

    @Override
    @JsonProperty(value="ymin")
    public double getYmin() {
        return this.ymin;
    }

    @Override
    @JsonProperty(value="xmax")
    public double getXmax() {
        return this.xmax;
    }

    @Override
    @JsonProperty(value="ymax")
    public double getYmax() {
        return this.ymax;
    }

    @Override
    @JsonProperty(value="epsgCrs")
    public ImmutableEpsgCrs getEpsgCrs() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getEpsgCrs() : this.epsgCrs;
    }

    @Override
    @JsonProperty(value="toArray")
    @JsonIgnore
    public double[] toArray() {
        InitShim shim = this.initShim;
        return shim != null ? shim.toArray() : this.toArray;
    }

    public final ImmutableBoundingBox withXmin(double value) {
        if (Double.doubleToLongBits(this.xmin) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableBoundingBox(value, this.ymin, this.xmax, this.ymax, this.epsgCrs);
    }

    public final ImmutableBoundingBox withYmin(double value) {
        if (Double.doubleToLongBits(this.ymin) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableBoundingBox(this.xmin, value, this.xmax, this.ymax, this.epsgCrs);
    }

    public final ImmutableBoundingBox withXmax(double value) {
        if (Double.doubleToLongBits(this.xmax) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableBoundingBox(this.xmin, this.ymin, value, this.ymax, this.epsgCrs);
    }

    public final ImmutableBoundingBox withYmax(double value) {
        if (Double.doubleToLongBits(this.ymax) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableBoundingBox(this.xmin, this.ymin, this.xmax, value, this.epsgCrs);
    }

    public final ImmutableBoundingBox withEpsgCrs(EpsgCrs value) {
        if (this.epsgCrs == value) {
            return this;
        }
        ImmutableEpsgCrs newValue = ImmutableEpsgCrs.copyOf(value);
        return new ImmutableBoundingBox(this.xmin, this.ymin, this.xmax, this.ymax, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBoundingBox && this.equalTo((ImmutableBoundingBox)another);
    }

    private boolean equalTo(ImmutableBoundingBox another) {
        return Double.doubleToLongBits(this.xmin) == Double.doubleToLongBits(another.xmin) && Double.doubleToLongBits(this.ymin) == Double.doubleToLongBits(another.ymin) && Double.doubleToLongBits(this.xmax) == Double.doubleToLongBits(another.xmax) && Double.doubleToLongBits(this.ymax) == Double.doubleToLongBits(another.ymax) && this.epsgCrs.equals(another.epsgCrs);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Doubles.hashCode(this.xmin);
        h += (h << 5) + Doubles.hashCode(this.ymin);
        h += (h << 5) + Doubles.hashCode(this.xmax);
        h += (h << 5) + Doubles.hashCode(this.ymax);
        h += (h << 5) + this.epsgCrs.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("BoundingBox").omitNullValues().add("xmin", this.xmin).add("ymin", this.ymin).add("xmax", this.xmax).add("ymax", this.ymax).add("epsgCrs", this.epsgCrs).toString();
    }

    public static ImmutableBoundingBox copyOf(BoundingBox instance) {
        if (instance instanceof ImmutableBoundingBox) {
            return (ImmutableBoundingBox)instance;
        }
        return new Builder().from(instance).build();
    }

    @Generated(from="BoundingBox", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_XMIN = 1L;
        private static final long INIT_BIT_YMIN = 2L;
        private static final long INIT_BIT_XMAX = 4L;
        private static final long INIT_BIT_YMAX = 8L;
        private long initBits = 15L;
        private double xmin;
        private double ymin;
        private double xmax;
        private double ymax;
        @Nullable
        private EpsgCrs epsgCrs;

        @CanIgnoreReturnValue
        public final Builder from(BoundingBox instance) {
            Objects.requireNonNull(instance, "instance");
            this.xmin(instance.getXmin());
            this.ymin(instance.getYmin());
            this.xmax(instance.getXmax());
            this.ymax(instance.getYmax());
            this.epsgCrs(instance.getEpsgCrs());
            return this;
        }

        @JsonProperty(value="xmin")
        @CanIgnoreReturnValue
        public final Builder xmin(double xmin) {
            this.xmin = xmin;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="ymin")
        @CanIgnoreReturnValue
        public final Builder ymin(double ymin) {
            this.ymin = ymin;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="xmax")
        @CanIgnoreReturnValue
        public final Builder xmax(double xmax) {
            this.xmax = xmax;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="ymax")
        @CanIgnoreReturnValue
        public final Builder ymax(double ymax) {
            this.ymax = ymax;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder epsgCrs(int code) {
            return this.epsgCrs(ImmutableEpsgCrs.of(code));
        }

        @JsonProperty(value="epsgCrs")
        @CanIgnoreReturnValue
        public final Builder epsgCrs(EpsgCrs epsgCrs) {
            this.epsgCrs = ImmutableEpsgCrs.copyOf(epsgCrs);
            return this;
        }

        public ImmutableBoundingBox build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBoundingBox(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("xmin");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("ymin");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("xmax");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("ymax");
            }
            return "Cannot build BoundingBox, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="BoundingBox", generator="Immutables")
    private final class InitShim {
        private byte epsgCrsBuildStage = 0;
        private ImmutableEpsgCrs epsgCrs;
        private byte toArrayBuildStage = 0;
        private double[] toArray;

        private InitShim() {
        }

        ImmutableEpsgCrs getEpsgCrs() {
            if (this.epsgCrsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.epsgCrsBuildStage == 0) {
                this.epsgCrsBuildStage = (byte)-1;
                this.epsgCrs = ImmutableEpsgCrs.copyOf(ImmutableBoundingBox.this.getEpsgCrsInitialize());
                this.epsgCrsBuildStage = 1;
            }
            return this.epsgCrs;
        }

        void epsgCrs(ImmutableEpsgCrs epsgCrs) {
            this.epsgCrs = epsgCrs;
            this.epsgCrsBuildStage = 1;
        }

        double[] toArray() {
            if (this.toArrayBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toArrayBuildStage == 0) {
                this.toArrayBuildStage = (byte)-1;
                this.toArray = Objects.requireNonNull(ImmutableBoundingBox.this.toArrayInitialize(), "toArray");
                this.toArrayBuildStage = 1;
            }
            return this.toArray;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.epsgCrsBuildStage == -1) {
                attributes.add("epsgCrs");
            }
            if (this.toArrayBuildStage == -1) {
                attributes.add("toArray");
            }
            return "Cannot build BoundingBox, attribute initializers form cycle " + attributes;
        }
    }
}

