/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.crs.domain;

import de.ii.xtraplatform.crs.domain.ImmutableEpsgCrs;
import de.ii.xtraplatform.crs.domain.OgcCrs;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import shadow.com.fasterxml.jackson.annotation.JsonInclude;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.org.immutables.value.Value;

@JsonDeserialize(builder=ImmutableEpsgCrs.Builder.class)
@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@Value.Immutable
@Value.Style(builder="new")
public interface EpsgCrs {
    public static EpsgCrs of(int code) {
        return ImmutableEpsgCrs.of(code);
    }

    public static EpsgCrs of(int code, Force force) {
        return new ImmutableEpsgCrs.Builder().code(code).forceAxisOrder(force).build();
    }

    public static EpsgCrs of(int code, int verticalCode) {
        return new ImmutableEpsgCrs.Builder().code(code).verticalCode(verticalCode).build();
    }

    public static EpsgCrs of(int code, int verticalCode, Force force) {
        return new ImmutableEpsgCrs.Builder().code(code).verticalCode(verticalCode).forceAxisOrder(force).build();
    }

    public static EpsgCrs fromString(String prefixedCode) {
        int code;
        Optional<EpsgCrs> ogcCrs = OgcCrs.fromString(prefixedCode);
        if (ogcCrs.isPresent()) {
            return ogcCrs.get();
        }
        try {
            code = Integer.parseInt(prefixedCode.substring(prefixedCode.lastIndexOf(":") + 1));
        }
        catch (NumberFormatException e) {
            try {
                code = Integer.parseInt(prefixedCode.substring(prefixedCode.lastIndexOf("/") + 1));
            }
            catch (NumberFormatException e2) {
                try {
                    code = Integer.parseInt(prefixedCode);
                }
                catch (NumberFormatException e3) {
                    throw new IllegalArgumentException("Could not parse CRS: " + prefixedCode);
                }
            }
        }
        return ImmutableEpsgCrs.of(code);
    }

    public static EpsgCrs fromString(String prefixedCode, String prefixedCodeVertical) {
        EpsgCrs crs = EpsgCrs.fromString(prefixedCode);
        EpsgCrs verticalCrs = EpsgCrs.fromString(prefixedCodeVertical);
        return new ImmutableEpsgCrs.Builder().code(crs.getCode()).verticalCode(verticalCrs.getCode()).build();
    }

    @Value.Parameter
    public int getCode();

    public OptionalInt getVerticalCode();

    @Deprecated
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @Value.Default
    @Value.Auxiliary
    default public boolean getForceLongitudeFirst() {
        return false;
    }

    @Value.Default
    default public Force getForceAxisOrder() {
        return this.getForceLongitudeFirst() ? Force.LON_LAT : Force.NONE;
    }

    @Value.Lazy
    default public String toSimpleString() {
        return String.format("EPSG:%d", this.getCode());
    }

    @Value.Lazy
    default public String toUrnString() {
        return String.format("urn:ogc:def:crs:EPSG::%d", this.getCode());
    }

    @Value.Lazy
    default public String toUriString() {
        if (Objects.equals(this, OgcCrs.CRS84)) {
            return "http://www.opengis.net/def/crs/OGC/1.3/CRS84";
        }
        if (Objects.equals(this, OgcCrs.CRS84h)) {
            return "http://www.opengis.net/def/crs/OGC/0/CRS84h";
        }
        return String.format("http://www.opengis.net/def/crs/EPSG/0/%d", this.getCode());
    }

    @Value.Lazy
    default public String toHumanReadableString() {
        String lonlat = this.getForceAxisOrder() == Force.LON_LAT ? String.format(" (%s)", new Object[]{Force.LON_LAT}) : "";
        String vertical = this.getVerticalCode().isPresent() ? String.format(" + EPSG:%d", this.getVerticalCode().getAsInt()) : "";
        return this.toSimpleString() + lonlat + vertical;
    }

    public static enum Force {
        NONE,
        LON_LAT,
        LAT_LON;

    }
}

