/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.crs.domain;

import de.ii.xtraplatform.crs.domain.EpsgCrs;
import de.ii.xtraplatform.crs.domain.ImmutableBoundingBox;
import de.ii.xtraplatform.crs.domain.OgcCrs;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.org.immutables.value.Value;

@JsonDeserialize(builder=ImmutableBoundingBox.Builder.class)
@Value.Immutable
@Value.Style(builder="new", deepImmutablesDetection=true)
public interface BoundingBox {
    public static BoundingBox of(double xmin, double ymin, double xmax, double ymax, EpsgCrs crs) {
        return new ImmutableBoundingBox.Builder().xmin(xmin).ymin(ymin).xmax(xmax).ymax(ymax).epsgCrs(crs).build();
    }

    public double getXmin();

    public double getYmin();

    public double getXmax();

    public double getYmax();

    @Value.Default
    default public EpsgCrs getEpsgCrs() {
        return OgcCrs.CRS84;
    }

    @JsonIgnore
    @Value.Derived
    @Value.Auxiliary
    default public double[] toArray() {
        return new double[]{this.getXmin(), this.getYmin(), this.getXmax(), this.getYmax()};
    }
}

