/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.cql.domain;

import de.ii.xtraplatform.cql.domain.BinaryOperation;
import de.ii.xtraplatform.cql.domain.CqlNode;
import de.ii.xtraplatform.cql.domain.Function;
import de.ii.xtraplatform.cql.domain.ImmutableTemporalOperation;
import de.ii.xtraplatform.cql.domain.Operand;
import de.ii.xtraplatform.cql.domain.Property;
import de.ii.xtraplatform.cql.domain.Temporal;
import de.ii.xtraplatform.cql.domain.TemporalLiteral;
import de.ii.xtraplatform.cql.domain.TemporalOperator;
import java.util.List;
import shadow.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.com.fasterxml.jackson.annotation.JsonValue;
import shadow.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.com.google.common.base.Preconditions;
import shadow.com.google.common.collect.ImmutableList;
import shadow.org.immutables.value.Value;
import shadow.org.threeten.extra.Interval;

@JsonDeserialize(as=TemporalOperation.class)
@Value.Immutable
public interface TemporalOperation
extends BinaryOperation<TemporalLiteral>,
CqlNode {
    public static final List<TemporalOperator> INTERVAL_ONLY = ImmutableList.of(TemporalOperator.T_CONTAINS, TemporalOperator.T_DURING, TemporalOperator.T_FINISHEDBY, TemporalOperator.T_FINISHES, TemporalOperator.T_MEETS, TemporalOperator.T_METBY, TemporalOperator.T_OVERLAPPEDBY, TemporalOperator.T_OVERLAPS, TemporalOperator.T_STARTEDBY, TemporalOperator.T_STARTS);

    @JsonValue
    public TemporalOperator getOperator();

    @JsonCreator
    public static TemporalOperation of(TemporalOperator operator, List<Operand> operands) {
        return ((ImmutableTemporalOperation.Builder)new ImmutableTemporalOperation.Builder().operator(operator).operands(operands)).build();
    }

    public static TemporalOperation of(TemporalOperator operator, Temporal temporal1, Temporal temporal2) {
        return ((ImmutableTemporalOperation.Builder)new ImmutableTemporalOperation.Builder().operator(operator).operands(ImmutableList.of(temporal1, temporal2))).build();
    }

    public static TemporalOperation of(TemporalOperator operator, String property, TemporalLiteral temporalLiteral) {
        return ((ImmutableTemporalOperation.Builder)new ImmutableTemporalOperation.Builder().operator(operator).operands(ImmutableList.of(Property.of(property), temporalLiteral))).build();
    }

    public static TemporalOperation of(TemporalOperator operator, String property, String property2) {
        return ((ImmutableTemporalOperation.Builder)new ImmutableTemporalOperation.Builder().operator(operator).operands(ImmutableList.of(Property.of(property), Property.of(property2)))).build();
    }

    @Override
    @Value.Check
    default public void check() {
        BinaryOperation.super.check();
        this.getOperands().forEach(operand -> {
            Preconditions.checkState(operand instanceof Temporal, "a temporal operation must have temporal operands, found %s", (Object)operand.getClass().getSimpleName());
            if (operand instanceof Function) {
                Preconditions.checkState(((Function)operand).isInterval(), "The arguments of %s must be an INTERVAL(). Found: a function '%s' of type '%s'.", (Object)this.getOperator().toString(), (Object)((Function)operand).getName(), ((Function)operand).getType());
            }
            if (INTERVAL_ONLY.contains(this.getOperator())) {
                if (operand instanceof Property) {
                    Preconditions.checkState(true, "The arguments of %s must be an INTERVAL(). Found: a property ('%s').", (Object)this.getOperator().toString(), (Object)((Property)operand).getName());
                }
                if (operand instanceof TemporalLiteral) {
                    Preconditions.checkState(((TemporalLiteral)operand).getType() == Interval.class || ((TemporalLiteral)operand).getType() == Function.class && ((Function)((TemporalLiteral)operand).getValue()).isInterval(), "The arguments of %s must be an INTERVAL(). Found: a temporal literal '%s' of type '%s'.", (Object)this.getOperator().toString(), ((TemporalLiteral)operand).getValue(), ((TemporalLiteral)operand).getType());
                }
            }
        });
    }

    public static abstract class Builder
    extends BinaryOperation.Builder<TemporalLiteral, TemporalOperation> {
    }
}

