/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.cql.domain;

import de.ii.xtraplatform.cql.domain.CqlNode;
import de.ii.xtraplatform.cql.domain.CqlParseException;
import de.ii.xtraplatform.cql.domain.Function;
import de.ii.xtraplatform.cql.domain.ImmutableTemporalLiteral;
import de.ii.xtraplatform.cql.domain.Literal;
import de.ii.xtraplatform.cql.domain.Scalar;
import de.ii.xtraplatform.cql.domain.Temporal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import shadow.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.com.google.common.collect.ImmutableList;
import shadow.org.immutables.value.Value;
import shadow.org.threeten.extra.Interval;

@JsonDeserialize(builder=Builder.class)
@Value.Immutable
public interface TemporalLiteral
extends Temporal,
Scalar,
Literal,
CqlNode {
    public static final String DATE_REGEX = "(?:[0-9]+)-(?:0[1-9]|1[012])-(?:0[1-9]|[12][0-9]|3[01])";
    public static final String TIMESTAMP_REGEX = "(?:[0-9]+)-(?:0[1-9]|1[012])-(?:0[1-9]|[12][0-9]|3[01])T(?:[01][0-9]|2[0-3]):(?:[0-5][0-9]):(?:[0-5][0-9]|60)(?:\\.[0-9]+)?Z";
    public static final Predicate<String> TIMESTAMP_PATTERN;
    public static final Predicate<String> DATE_PATTERN;

    public static TemporalLiteral of(Instant instant) {
        return new Builder(instant).build();
    }

    public static TemporalLiteral of(String startInclusive, String endInclusive) {
        return new Builder(TemporalLiteral.of(startInclusive), TemporalLiteral.of(endInclusive)).build();
    }

    public static TemporalLiteral of(TemporalLiteral startInclusive, TemporalLiteral endInclusive) {
        return new Builder(startInclusive, endInclusive).build();
    }

    public static TemporalLiteral of(List<String> startEndInclusive) {
        if (!1.$assertionsDisabled && startEndInclusive.size() < 2) {
            throw new AssertionError();
        }
        return new Builder(TemporalLiteral.of(startEndInclusive.get(0)), TemporalLiteral.of(startEndInclusive.get(1))).build();
    }

    public static TemporalLiteral of(Instant startInclusive, Instant endExclusive) {
        return new Builder(startInclusive, endExclusive).build();
    }

    public static TemporalLiteral of(String instantLiteral) throws CqlParseException {
        return new Builder(instantLiteral).build();
    }

    public static Instant now() {
        return Instant.now().truncatedTo(ChronoUnit.SECONDS);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        TIMESTAMP_PATTERN = Pattern.compile(String.format("^%s$", TIMESTAMP_REGEX)).asPredicate();
        DATE_PATTERN = Pattern.compile(String.format("^%s$", DATE_REGEX)).asPredicate();
    }

    public static class Builder
    extends ImmutableTemporalLiteral.Builder {
        public Builder() {
        }

        public Builder(Instant instant) {
            this.value(instant);
            this.type(Instant.class);
        }

        public Builder(Instant startInclusive, Instant endExclusive) {
            this.value(Interval.of(startInclusive, endExclusive));
            this.type(Interval.class);
        }

        public Builder(Interval interval) {
            this.value(interval);
            this.type(Interval.class);
        }

        @JsonCreator
        public Builder(String instantLiteral) throws CqlParseException {
            Object castedLiteral = this.castToType(instantLiteral);
            this.value(castedLiteral);
            this.type(castedLiteral.getClass());
        }

        public Builder(TemporalLiteral startInclusive, TemporalLiteral endInclusive) throws CqlParseException {
            if (!(startInclusive.getType() != Instant.class && startInclusive.getType() != OPEN.class || endInclusive.getType() != Instant.class && endInclusive.getType() != OPEN.class)) {
                this.value(Interval.of(this.getStartInclusive(startInclusive.getValue()), this.getEndExclusive(endInclusive.getValue())));
                this.type(Interval.class);
            } else {
                this.value(Function.of("INTERVAL", ImmutableList.of(startInclusive, endInclusive)));
                this.type(Function.class);
            }
        }

        private Instant getStartInclusive(Object instant) {
            if (instant instanceof OPEN) {
                return Instant.MIN;
            }
            if (instant instanceof LocalDate) {
                return ((LocalDate)instant).atStartOfDay(ZoneOffset.UTC).toInstant();
            }
            return (Instant)instant;
        }

        private Instant getEndExclusive(Object instant) {
            if (instant instanceof OPEN) {
                return Instant.MAX;
            }
            if (instant instanceof LocalDate) {
                return ((LocalDate)instant).plusDays(1L).atStartOfDay(ZoneOffset.UTC).toInstant();
            }
            return ((Instant)instant).plusSeconds(1L);
        }

        private Object castToType(String instantLiteral) throws CqlParseException {
            try {
                if (TIMESTAMP_PATTERN.test(instantLiteral.toUpperCase())) {
                    return ZonedDateTime.parse(instantLiteral).toInstant();
                }
                if (DATE_PATTERN.test(instantLiteral.toUpperCase())) {
                    return LocalDate.parse(instantLiteral);
                }
                if (instantLiteral.equalsIgnoreCase("NOW()")) {
                    return Instant.now();
                }
                if (instantLiteral.equals("..")) {
                    return OPEN.OPEN;
                }
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
            throw new CqlParseException("not a valid instant literal: " + instantLiteral);
        }
    }

    public static enum OPEN {
        OPEN;

    }
}

