/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.cql.domain;

import de.ii.xtraplatform.cql.domain.BinaryOperation;
import de.ii.xtraplatform.cql.domain.CqlNode;
import de.ii.xtraplatform.cql.domain.Geometry;
import de.ii.xtraplatform.cql.domain.ImmutableSpatialOperation;
import de.ii.xtraplatform.cql.domain.Operand;
import de.ii.xtraplatform.cql.domain.Property;
import de.ii.xtraplatform.cql.domain.Spatial;
import de.ii.xtraplatform.cql.domain.SpatialLiteral;
import de.ii.xtraplatform.cql.domain.SpatialOperator;
import de.ii.xtraplatform.crs.domain.BoundingBox;
import java.util.List;
import shadow.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.com.fasterxml.jackson.annotation.JsonValue;
import shadow.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.com.google.common.base.Preconditions;
import shadow.com.google.common.collect.ImmutableList;
import shadow.org.immutables.value.Value;

@JsonDeserialize(as=SpatialOperation.class)
@Value.Immutable
public interface SpatialOperation
extends BinaryOperation<SpatialLiteral>,
CqlNode {
    @JsonValue
    public SpatialOperator getOperator();

    @JsonCreator
    public static SpatialOperation of(SpatialOperator operator, List<Operand> operands) {
        return ((ImmutableSpatialOperation.Builder)new ImmutableSpatialOperation.Builder().operator(operator).operands(operands)).build();
    }

    public static SpatialOperation of(SpatialOperator operator, Spatial temporal1, Spatial temporal2) {
        return ((ImmutableSpatialOperation.Builder)new ImmutableSpatialOperation.Builder().operator(operator).operands(ImmutableList.of(temporal1, temporal2))).build();
    }

    public static SpatialOperation of(SpatialOperator operator, String property, SpatialLiteral temporalLiteral) {
        return ((ImmutableSpatialOperation.Builder)new ImmutableSpatialOperation.Builder().operator(operator).operands(ImmutableList.of(Property.of(property), temporalLiteral))).build();
    }

    public static SpatialOperation of(SpatialOperator operator, String property, String property2) {
        return ((ImmutableSpatialOperation.Builder)new ImmutableSpatialOperation.Builder().operator(operator).operands(ImmutableList.of(Property.of(property), Property.of(property2)))).build();
    }

    public static SpatialOperation of(SpatialOperator operator, String property, BoundingBox boundingBox) {
        return ((ImmutableSpatialOperation.Builder)new ImmutableSpatialOperation.Builder().operator(operator).operands(ImmutableList.of(Property.of(property), SpatialLiteral.of(Geometry.Envelope.of(boundingBox))))).build();
    }

    @Override
    @Value.Check
    default public void check() {
        BinaryOperation.super.check();
        this.getOperands().forEach(operand -> Preconditions.checkState(operand instanceof Spatial, "a spatial operation must have spatial operands, found %s", (Object)operand.getClass().getSimpleName()));
    }

    public static abstract class Builder
    extends BinaryOperation.Builder<SpatialLiteral, SpatialOperation> {
    }
}

