/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.cql.domain;

import de.ii.xtraplatform.cql.domain.CqlNode;
import de.ii.xtraplatform.cql.domain.ImmutableScalarLiteral;
import de.ii.xtraplatform.cql.domain.Literal;
import de.ii.xtraplatform.cql.domain.Scalar;
import shadow.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.org.immutables.value.Value;

@JsonDeserialize(builder=ImmutableScalarLiteral.Builder.class)
@Value.Immutable
public interface ScalarLiteral
extends Scalar,
Literal,
CqlNode {
    public static ScalarLiteral of(Double literal) {
        return new Builder(literal).build();
    }

    public static ScalarLiteral of(Integer literal) {
        return new Builder(literal).build();
    }

    public static ScalarLiteral of(Long literal) {
        return new Builder(literal).build();
    }

    public static ScalarLiteral of(Boolean literal) {
        return new Builder(literal).build();
    }

    public static ScalarLiteral of(String literal) {
        return new Builder(literal).build();
    }

    public static ScalarLiteral of(String literal, boolean determineType) {
        return new Builder(literal, determineType).build();
    }

    public static class Builder
    extends ImmutableScalarLiteral.Builder {
        public Builder() {
        }

        @JsonCreator
        public Builder(Double literal) {
            this.value(literal);
            this.type(Double.class);
        }

        @JsonCreator
        public Builder(Integer literal) {
            this.value(literal);
            this.type(Integer.class);
        }

        @JsonCreator
        public Builder(Long literal) {
            this.value(literal);
            this.type(Long.class);
        }

        @JsonCreator
        public Builder(Boolean literal) {
            this.value(literal);
            this.type(Boolean.class);
        }

        @JsonCreator
        public Builder(String literal) {
            this(literal, false);
        }

        public Builder(String literal, boolean determineType) {
            if (determineType) {
                Object castedLiteral = this.castToType(literal);
                this.value(castedLiteral);
                this.type(castedLiteral.getClass());
            } else {
                this.value(literal);
                this.type(String.class);
            }
        }

        private Object castToType(String literal) {
            try {
                return Integer.valueOf(literal);
            }
            catch (NumberFormatException e) {
                try {
                    return Long.valueOf(literal);
                }
                catch (NumberFormatException e2) {
                    try {
                        return Double.valueOf(literal);
                    }
                    catch (NumberFormatException e3) {
                        if (literal.equalsIgnoreCase("true") || literal.equalsIgnoreCase("false")) {
                            return Boolean.valueOf(literal);
                        }
                        return literal;
                    }
                }
            }
        }
    }
}

