/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.cql.domain;

import de.ii.xtraplatform.cql.domain.CqlFilter;
import de.ii.xtraplatform.cql.domain.CqlNode;
import de.ii.xtraplatform.cql.domain.ImmutableProperty;
import de.ii.xtraplatform.cql.domain.Operand;
import de.ii.xtraplatform.cql.domain.Scalar;
import de.ii.xtraplatform.cql.domain.Spatial;
import de.ii.xtraplatform.cql.domain.Temporal;
import de.ii.xtraplatform.cql.domain.Vector;
import java.util.List;
import java.util.Map;
import shadow.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.com.google.common.base.Splitter;
import shadow.org.immutables.value.Value;

@JsonDeserialize(builder=ImmutableProperty.Builder.class)
@Value.Immutable
@Value.Style(of="new")
public interface Property
extends Scalar,
Spatial,
Temporal,
Operand,
Vector,
CqlNode {
    public static final Splitter PATH_SPLITTER = Splitter.on('.').omitEmptyStrings();

    @JsonCreator
    public static Property of(String name) {
        return ImmutableProperty.builder().name(name).build();
    }

    public static Property of(String name, Map<String, CqlFilter> nestedFilters) {
        return ImmutableProperty.builder().name(name).nestedFilters(nestedFilters).build();
    }

    @JsonProperty(value="property")
    public String getName();

    @JsonIgnore
    public Map<String, CqlFilter> getNestedFilters();

    @JsonIgnore
    @Value.Derived
    default public List<String> getPath() {
        return PATH_SPLITTER.splitToList(this.getName());
    }
}

