/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.cql.domain;

import de.ii.xtraplatform.cql.domain.ArrayOperator;
import de.ii.xtraplatform.cql.domain.CqlNode;
import de.ii.xtraplatform.cql.domain.Function;
import de.ii.xtraplatform.cql.domain.Geometry;
import de.ii.xtraplatform.cql.domain.Property;
import de.ii.xtraplatform.cql.domain.Scalar;
import de.ii.xtraplatform.cql.domain.ScalarLiteral;
import de.ii.xtraplatform.cql.domain.SpatialLiteral;
import de.ii.xtraplatform.cql.domain.SpatialOperator;
import de.ii.xtraplatform.cql.domain.TemporalLiteral;
import de.ii.xtraplatform.cql.domain.TemporalOperator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import shadow.com.fasterxml.jackson.core.JsonParseException;
import shadow.com.fasterxml.jackson.core.JsonParser;
import shadow.com.fasterxml.jackson.core.JsonProcessingException;
import shadow.com.fasterxml.jackson.core.ObjectCodec;
import shadow.com.fasterxml.jackson.databind.DeserializationContext;
import shadow.com.fasterxml.jackson.databind.JsonMappingException;
import shadow.com.fasterxml.jackson.databind.JsonNode;
import shadow.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import shadow.com.google.common.collect.ImmutableList;

@JsonDeserialize(using=OperandDeserializer.class)
public interface Operand
extends CqlNode {

    public static class OperandDeserializer
    extends StdDeserializer<Operand> {
        private static final List<String> ARRAY = Arrays.stream(ArrayOperator.values()).map(op -> op.toString().toLowerCase()).collect(Collectors.toUnmodifiableList());
        private static final List<String> SPATIAL = Arrays.stream(SpatialOperator.values()).map(op -> op.toString().toLowerCase()).collect(Collectors.toUnmodifiableList());
        private static final List<String> TEMPORAL = Arrays.stream(TemporalOperator.values()).map(op -> op.toString().toLowerCase()).collect(Collectors.toUnmodifiableList());
        private static final List<String> SCALAR = ImmutableList.of("value", "list", "operands", "eq", "neq", "gt", "gte", "lt", "lte", "between", "in", "isnull", new String[0]);

        protected OperandDeserializer() {
            this((Class<?>)null);
        }

        protected OperandDeserializer(Class<?> vc) {
            super(vc);
        }

        private Scalar getScalar(JsonNode node) {
            if (node.isBoolean()) {
                return ScalarLiteral.of(node.asBoolean());
            }
            if (node.isInt()) {
                return ScalarLiteral.of(node.asInt());
            }
            if (node.isLong()) {
                return ScalarLiteral.of(node.asLong());
            }
            if (node.isDouble()) {
                return ScalarLiteral.of(node.asDouble());
            }
            return ScalarLiteral.of(node.asText());
        }

        private Operand getOperand(JsonParser parser, JsonNode node, String parent) throws JsonProcessingException {
            ObjectCodec oc = parser.getCodec();
            if (node.isObject()) {
                if (Objects.nonNull(node.get("property"))) {
                    return oc.treeToValue(node, Property.class);
                }
                if (Objects.nonNull(node.get("function"))) {
                    ArrayList<Operand> list = new ArrayList<Operand>();
                    Iterator<JsonNode> iterator = node.get("function").get("arguments").elements();
                    while (iterator.hasNext()) {
                        JsonNode listNode = iterator.next();
                        list.add(this.getOperand(parser, listNode, "arguments"));
                    }
                    return Function.of(node.get("function").get("name").textValue(), list);
                }
                if (SPATIAL.contains(parent)) {
                    return SpatialLiteral.of(oc.treeToValue(node, Geometry.class));
                }
            } else if (node.isArray()) {
                if (TEMPORAL.contains(parent)) {
                    return oc.treeToValue(node, TemporalLiteral.class);
                }
            } else if (node.isValueNode()) {
                if (SCALAR.contains(parent)) {
                    return this.getScalar(node);
                }
                if (TEMPORAL.contains(parent)) {
                    return oc.treeToValue(node, TemporalLiteral.class);
                }
                try {
                    return oc.treeToValue(node, TemporalLiteral.class);
                }
                catch (JsonProcessingException e) {
                    return this.getScalar(node);
                }
            }
            throw new JsonParseException(parser, String.format("Unexpected operand of type %s in member %s.", new Object[]{node.getNodeType(), parent}));
        }

        @Override
        public Operand deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException, JsonMappingException {
            JsonNode node = (JsonNode)parser.getCodec().readTree(parser);
            String parent = parser.getParsingContext().getParent().getCurrentName().toLowerCase();
            return this.getOperand(parser, node, parent);
        }
    }
}

