/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.cql.domain;

import de.ii.xtraplatform.cql.domain.BinaryOperation;
import de.ii.xtraplatform.cql.domain.CqlNode;
import de.ii.xtraplatform.cql.domain.CqlPredicate;
import de.ii.xtraplatform.cql.domain.CqlVisitor;
import de.ii.xtraplatform.cql.domain.ImmutableNot;
import de.ii.xtraplatform.cql.domain.NonBinaryScalarOperation;
import java.util.Optional;
import shadow.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.com.fasterxml.jackson.annotation.JsonValue;
import shadow.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.com.google.common.base.Preconditions;
import shadow.com.google.common.collect.Lists;
import shadow.org.immutables.value.Value;

@JsonDeserialize(as=Not.class)
@Value.Immutable
public interface Not
extends CqlNode {
    @JsonValue
    public Optional<CqlPredicate> getPredicate();

    @JsonCreator
    public static Not of(CqlPredicate predicate) {
        return new ImmutableNot.Builder().predicate(predicate).build();
    }

    public static Not of(BinaryOperation<?> binaryOperation) {
        return new ImmutableNot.Builder().predicate(CqlPredicate.of(binaryOperation)).build();
    }

    public static Not of(NonBinaryScalarOperation scalarOperation) {
        return new ImmutableNot.Builder().predicate(CqlPredicate.of(scalarOperation)).build();
    }

    @Value.Check
    default public void check() {
        Preconditions.checkState(this.getPredicate().isPresent(), "a NOT operation must have one child, found 0");
    }

    @Override
    default public <T> T accept(CqlVisitor<T> visitor) {
        T expression = this.getPredicate().get().accept(visitor);
        return (T)visitor.visit(this, Lists.newArrayList(expression));
    }
}

