/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.cql.domain;

import de.ii.xtraplatform.cql.domain.CqlNode;
import de.ii.xtraplatform.cql.domain.CqlVisitor;
import de.ii.xtraplatform.cql.domain.Function;
import de.ii.xtraplatform.cql.domain.ImmutableLike;
import de.ii.xtraplatform.cql.domain.NonBinaryScalarOperation;
import de.ii.xtraplatform.cql.domain.Operand;
import de.ii.xtraplatform.cql.domain.Property;
import de.ii.xtraplatform.cql.domain.ScalarLiteral;
import java.util.List;
import shadow.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.com.google.common.base.Preconditions;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.common.collect.Lists;
import shadow.org.immutables.value.Value;

@JsonDeserialize(builder=ImmutableLike.Builder.class)
@Value.Immutable
public interface Like
extends NonBinaryScalarOperation,
CqlNode {
    public static Like of(String property, ScalarLiteral scalarLiteral) {
        return ((ImmutableLike.Builder)new ImmutableLike.Builder().operands(ImmutableList.of(Property.of(property), scalarLiteral))).build();
    }

    public static Like of(String property, String property2) {
        return ((ImmutableLike.Builder)new ImmutableLike.Builder().operands(ImmutableList.of(Property.of(property), Property.of(property2)))).build();
    }

    public static Like ofFunction(Function function, ScalarLiteral scalarLiteral) {
        return ((ImmutableLike.Builder)new ImmutableLike.Builder().operands(ImmutableList.of(function, scalarLiteral))).build();
    }

    public List<Operand> getOperands();

    @Value.Check
    default public void check() {
        int count = this.getOperands().size();
        Preconditions.checkState(count == 2, "a LIKE operation must have exactly two operands, found %s", count);
    }

    default public <U> U accept(CqlVisitor<U> visitor) {
        U operand1 = this.getOperands().get(0).accept(visitor);
        U operand2 = this.getOperands().get(1).accept(visitor);
        return (U)visitor.visit(this, Lists.newArrayList(operand1, operand2));
    }

    public static abstract class Builder {
        public abstract Like build();

        public abstract Builder operands(Iterable<? extends Operand> var1);
    }
}

