/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.cql.domain;

import de.ii.xtraplatform.cql.domain.CqlNode;
import de.ii.xtraplatform.cql.domain.CqlVisitor;
import de.ii.xtraplatform.cql.domain.Function;
import de.ii.xtraplatform.cql.domain.ImmutableIsNull;
import de.ii.xtraplatform.cql.domain.NonBinaryScalarOperation;
import de.ii.xtraplatform.cql.domain.Operand;
import de.ii.xtraplatform.cql.domain.Property;
import java.util.Optional;
import shadow.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.com.fasterxml.jackson.annotation.JsonValue;
import shadow.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.com.google.common.base.Preconditions;
import shadow.com.google.common.collect.Lists;
import shadow.org.immutables.value.Value;

@JsonDeserialize(as=IsNull.class)
@Value.Immutable
public interface IsNull
extends NonBinaryScalarOperation,
CqlNode {
    @JsonCreator
    public static IsNull of(String property) {
        return new ImmutableIsNull.Builder().operand(Property.of(property)).build();
    }

    @JsonCreator
    public static IsNull of(Property property) {
        return new ImmutableIsNull.Builder().operand(property).build();
    }

    @JsonCreator
    public static IsNull of(Function function) {
        return new ImmutableIsNull.Builder().operand(function).build();
    }

    @JsonValue
    public Optional<Operand> getOperand();

    @Value.Check
    default public void check() {
        Preconditions.checkState(this.getOperand().isPresent(), "IS NULL operation must have exactly one operand, found 0");
    }

    @Override
    default public <T> T accept(CqlVisitor<T> visitor) {
        return (T)visitor.visit(this, Lists.newArrayList(this.getOperand().get().accept(visitor)));
    }

    public static abstract class Builder {
        public abstract IsNull build();

        @JsonCreator
        public abstract Builder operand(Operand var1);
    }
}

