/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.cql.domain;

import de.ii.xtraplatform.cql.domain.CqlNode;
import de.ii.xtraplatform.cql.domain.CqlVisitor;
import de.ii.xtraplatform.cql.domain.Function;
import de.ii.xtraplatform.cql.domain.ImmutableIn;
import de.ii.xtraplatform.cql.domain.NonBinaryScalarOperation;
import de.ii.xtraplatform.cql.domain.Property;
import de.ii.xtraplatform.cql.domain.Scalar;
import de.ii.xtraplatform.cql.domain.TemporalLiteral;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import shadow.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.com.google.common.base.Preconditions;
import shadow.org.immutables.value.Value;

@JsonDeserialize(builder=ImmutableIn.Builder.class)
@Value.Immutable
public interface In
extends CqlNode,
NonBinaryScalarOperation {
    public static final String ID_PLACEHOLDER = "_ID_";

    public static In of(String property, List<Scalar> values) {
        return new ImmutableIn.Builder().value(Property.of(property)).list(values).build();
    }

    public static In of(String property, Scalar ... values) {
        return new ImmutableIn.Builder().value(Property.of(property)).list(Arrays.asList(values)).build();
    }

    public static In of(String property, TemporalLiteral ... values) {
        return new ImmutableIn.Builder().value(Property.of(property)).list(Arrays.asList(values)).build();
    }

    public static In of(Scalar ... values) {
        return new ImmutableIn.Builder().value(Property.of(ID_PLACEHOLDER)).addList(values).build();
    }

    public static In of(List<Scalar> values) {
        return new ImmutableIn.Builder().value(Property.of(ID_PLACEHOLDER)).list(values).build();
    }

    public static In ofFunction(Function function, List<Scalar> values) {
        return new ImmutableIn.Builder().value(function).list(values).build();
    }

    @Value.Check
    default public void check() {
        int count = this.getList().size();
        Preconditions.checkState(count > 0, "an IN operation must have at least one value, found %s", count);
        Preconditions.checkState(this.getValue().isPresent(), "an IN operation must have exactly one operand, found 0");
    }

    public Optional<Scalar> getValue();

    public List<Scalar> getList();

    @Override
    default public <T> T accept(CqlVisitor<T> visitor) {
        List children = Stream.concat(Stream.of(this.getValue().get()), this.getList().stream()).map(value -> value.accept(visitor)).collect(Collectors.toList());
        return visitor.visit(this, children);
    }

    public static abstract class Builder {
        public abstract In build();

        public abstract Builder value(Scalar var1);
    }
}

