/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.cql.domain;

import de.ii.xtraplatform.cql.domain.CqlFilter;
import de.ii.xtraplatform.cql.domain.Property;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.common.collect.ImmutableMap;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Property", generator="Immutables")
@Immutable
public final class ImmutableProperty
implements Property {
    private final String name;
    private final ImmutableMap<String, CqlFilter> nestedFilters;
    private final transient List<String> path;

    private ImmutableProperty(String name, ImmutableMap<String, CqlFilter> nestedFilters) {
        this.name = name;
        this.nestedFilters = nestedFilters;
        this.path = Objects.requireNonNull(Property.super.getPath(), "path");
    }

    @Override
    @JsonProperty(value="property")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="nestedFilters")
    @JsonIgnore
    public ImmutableMap<String, CqlFilter> getNestedFilters() {
        return this.nestedFilters;
    }

    @Override
    @JsonProperty(value="path")
    @JsonIgnore
    public List<String> getPath() {
        return this.path;
    }

    public final ImmutableProperty withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableProperty(newValue, this.nestedFilters);
    }

    public final ImmutableProperty withNestedFilters(Map<String, ? extends CqlFilter> entries) {
        if (this.nestedFilters == entries) {
            return this;
        }
        ImmutableMap<String, CqlFilter> newValue = ImmutableMap.copyOf(entries);
        return new ImmutableProperty(this.name, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableProperty && this.equalTo((ImmutableProperty)another);
    }

    private boolean equalTo(ImmutableProperty another) {
        return this.name.equals(another.name) && this.nestedFilters.equals(another.nestedFilters) && this.path.equals(another.path);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.nestedFilters.hashCode();
        h += (h << 5) + this.path.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("Property").omitNullValues().add("name", this.name).add("nestedFilters", this.nestedFilters).add("path", this.path).toString();
    }

    public static ImmutableProperty copyOf(Property instance) {
        if (instance instanceof ImmutableProperty) {
            return (ImmutableProperty)instance;
        }
        return ImmutableProperty.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Property", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        @Nullable
        private String name;
        private ImmutableMap.Builder<String, CqlFilter> nestedFilters = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Property instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.getName());
            this.putAllNestedFilters(instance.getNestedFilters());
            return this;
        }

        @JsonProperty(value="property")
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putNestedFilters(String key, CqlFilter value) {
            this.nestedFilters.put(key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putNestedFilters(Map.Entry<String, ? extends CqlFilter> entry) {
            this.nestedFilters.put(entry);
            return this;
        }

        @JsonProperty(value="nestedFilters")
        @JsonIgnore
        @CanIgnoreReturnValue
        public final Builder nestedFilters(Map<String, ? extends CqlFilter> entries) {
            this.nestedFilters = ImmutableMap.builder();
            return this.putAllNestedFilters(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllNestedFilters(Map<String, ? extends CqlFilter> entries) {
            this.nestedFilters.putAll(entries);
            return this;
        }

        public ImmutableProperty build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableProperty(this.name, this.nestedFilters.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build Property, some of required attributes are not set " + attributes;
        }
    }
}

