/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.cql.domain;

import de.ii.xtraplatform.cql.domain.Geometry;
import de.ii.xtraplatform.cql.domain.ImmutablePoint;
import de.ii.xtraplatform.crs.domain.EpsgCrs;
import de.ii.xtraplatform.crs.domain.ImmutableEpsgCrs;
import java.util.Objects;
import java.util.Optional;
import shadow.com.fasterxml.jackson.annotation.JacksonInject;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Geometry.MultiPoint", generator="Immutables")
@Immutable
public final class ImmutableMultiPoint
implements Geometry.MultiPoint {
    private final ImmutableList<Geometry.Point> coordinates;
    @Nullable
    private final EpsgCrs crs;

    private ImmutableMultiPoint(ImmutableList<Geometry.Point> coordinates, @Nullable EpsgCrs crs) {
        this.coordinates = coordinates;
        this.crs = crs;
    }

    @Override
    @JsonProperty(value="coordinates")
    public ImmutableList<Geometry.Point> getCoordinates() {
        return this.coordinates;
    }

    @Override
    @JsonProperty(value="crs")
    @JsonIgnore
    @JacksonInject(value="filterCrs")
    public Optional<EpsgCrs> getCrs() {
        return Optional.ofNullable(this.crs);
    }

    public final ImmutableMultiPoint withCoordinates(Geometry.Point ... elements) {
        ImmutableList<Geometry.Point> newValue = ImmutableList.copyOf(elements);
        return new ImmutableMultiPoint(newValue, this.crs);
    }

    public final ImmutableMultiPoint withCoordinates(Iterable<? extends Geometry.Point> elements) {
        if (this.coordinates == elements) {
            return this;
        }
        ImmutableList<Geometry.Point> newValue = ImmutableList.copyOf(elements);
        return new ImmutableMultiPoint(newValue, this.crs);
    }

    public final ImmutableMultiPoint withCrs(EpsgCrs value) {
        EpsgCrs newValue = Objects.requireNonNull(value, "crs");
        if (this.crs == newValue) {
            return this;
        }
        return new ImmutableMultiPoint(this.coordinates, newValue);
    }

    public final ImmutableMultiPoint withCrs(Optional<? extends EpsgCrs> optional) {
        EpsgCrs value = optional.orElse(null);
        if (this.crs == value) {
            return this;
        }
        return new ImmutableMultiPoint(this.coordinates, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMultiPoint && this.equalTo((ImmutableMultiPoint)another);
    }

    private boolean equalTo(ImmutableMultiPoint another) {
        return this.coordinates.equals(another.coordinates) && Objects.equals(this.crs, another.crs);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.coordinates.hashCode();
        h += (h << 5) + Objects.hashCode(this.crs);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("MultiPoint").omitNullValues().add("coordinates", this.coordinates).add("crs", this.crs).toString();
    }

    public static ImmutableMultiPoint copyOf(Geometry.MultiPoint instance) {
        if (instance instanceof ImmutableMultiPoint) {
            return (ImmutableMultiPoint)instance;
        }
        return new Builder().from(instance).build();
    }

    @Generated(from="Geometry.MultiPoint", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private ImmutableList.Builder<Geometry.Point> coordinates = ImmutableList.builder();
        @Nullable
        private EpsgCrs crs;

        @CanIgnoreReturnValue
        public final Builder from(Geometry.MultiPoint instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllCoordinates(instance.getCoordinates());
            Optional<EpsgCrs> crsOptional = instance.getCrs();
            if (crsOptional.isPresent()) {
                this.crs(crsOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addCoordinates(Geometry.Point element) {
            element = ImmutablePoint.copyOf(element);
            this.coordinates.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addCoordinates(Geometry.Point ... elements) {
            for (Geometry.Point element : elements) {
                element = ImmutablePoint.copyOf(element);
                this.coordinates.add((Object)Objects.requireNonNull(element, "coordinates element"));
            }
            return this;
        }

        @JsonProperty(value="coordinates")
        @CanIgnoreReturnValue
        public final Builder coordinates(Iterable<? extends Geometry.Point> elements) {
            this.coordinates = ImmutableList.builder();
            return this.addAllCoordinates(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllCoordinates(Iterable<? extends Geometry.Point> elements) {
            for (Geometry.Point point : elements) {
                ImmutablePoint immutablePoint = ImmutablePoint.copyOf(point);
                this.coordinates.add((Object)Objects.requireNonNull(immutablePoint, "coordinates element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder crs(EpsgCrs crs) {
            this.crs = Objects.requireNonNull(crs, "crs");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder crs(int code) {
            return this.crs(ImmutableEpsgCrs.of(code));
        }

        @JsonProperty(value="crs")
        @JsonIgnore
        @JacksonInject(value="filterCrs")
        @CanIgnoreReturnValue
        public final Builder crs(Optional<? extends EpsgCrs> crs) {
            this.crs = crs.orElse(null);
            return this;
        }

        public ImmutableMultiPoint build() {
            return new ImmutableMultiPoint((ImmutableList<Geometry.Point>)this.coordinates.build(), this.crs);
        }
    }
}

