/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.cql.domain;

import de.ii.xtraplatform.cql.domain.Geometry;
import de.ii.xtraplatform.cql.domain.ImmutableLineString;
import de.ii.xtraplatform.crs.domain.EpsgCrs;
import de.ii.xtraplatform.crs.domain.ImmutableEpsgCrs;
import java.util.Objects;
import java.util.Optional;
import shadow.com.fasterxml.jackson.annotation.JacksonInject;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Geometry.MultiLineString", generator="Immutables")
@Immutable
public final class ImmutableMultiLineString
implements Geometry.MultiLineString {
    private final ImmutableList<Geometry.LineString> coordinates;
    @Nullable
    private final EpsgCrs crs;

    private ImmutableMultiLineString(ImmutableList<Geometry.LineString> coordinates, @Nullable EpsgCrs crs) {
        this.coordinates = coordinates;
        this.crs = crs;
    }

    @Override
    @JsonProperty(value="coordinates")
    public ImmutableList<Geometry.LineString> getCoordinates() {
        return this.coordinates;
    }

    @Override
    @JsonProperty(value="crs")
    @JsonIgnore
    @JacksonInject(value="filterCrs")
    public Optional<EpsgCrs> getCrs() {
        return Optional.ofNullable(this.crs);
    }

    public final ImmutableMultiLineString withCoordinates(Geometry.LineString ... elements) {
        ImmutableList<Geometry.LineString> newValue = ImmutableList.copyOf(elements);
        return new ImmutableMultiLineString(newValue, this.crs);
    }

    public final ImmutableMultiLineString withCoordinates(Iterable<? extends Geometry.LineString> elements) {
        if (this.coordinates == elements) {
            return this;
        }
        ImmutableList<Geometry.LineString> newValue = ImmutableList.copyOf(elements);
        return new ImmutableMultiLineString(newValue, this.crs);
    }

    public final ImmutableMultiLineString withCrs(EpsgCrs value) {
        EpsgCrs newValue = Objects.requireNonNull(value, "crs");
        if (this.crs == newValue) {
            return this;
        }
        return new ImmutableMultiLineString(this.coordinates, newValue);
    }

    public final ImmutableMultiLineString withCrs(Optional<? extends EpsgCrs> optional) {
        EpsgCrs value = optional.orElse(null);
        if (this.crs == value) {
            return this;
        }
        return new ImmutableMultiLineString(this.coordinates, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMultiLineString && this.equalTo((ImmutableMultiLineString)another);
    }

    private boolean equalTo(ImmutableMultiLineString another) {
        return this.coordinates.equals(another.coordinates) && Objects.equals(this.crs, another.crs);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.coordinates.hashCode();
        h += (h << 5) + Objects.hashCode(this.crs);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("MultiLineString").omitNullValues().add("coordinates", this.coordinates).add("crs", this.crs).toString();
    }

    public static ImmutableMultiLineString copyOf(Geometry.MultiLineString instance) {
        if (instance instanceof ImmutableMultiLineString) {
            return (ImmutableMultiLineString)instance;
        }
        return new Builder().from(instance).build();
    }

    @Generated(from="Geometry.MultiLineString", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private ImmutableList.Builder<Geometry.LineString> coordinates = ImmutableList.builder();
        @Nullable
        private EpsgCrs crs;

        @CanIgnoreReturnValue
        public final Builder from(Geometry.MultiLineString instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllCoordinates(instance.getCoordinates());
            Optional<EpsgCrs> crsOptional = instance.getCrs();
            if (crsOptional.isPresent()) {
                this.crs(crsOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addCoordinates(Geometry.LineString element) {
            element = ImmutableLineString.copyOf(element);
            this.coordinates.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addCoordinates(Geometry.LineString ... elements) {
            for (Geometry.LineString element : elements) {
                element = ImmutableLineString.copyOf(element);
                this.coordinates.add((Object)Objects.requireNonNull(element, "coordinates element"));
            }
            return this;
        }

        @JsonProperty(value="coordinates")
        @CanIgnoreReturnValue
        public final Builder coordinates(Iterable<? extends Geometry.LineString> elements) {
            this.coordinates = ImmutableList.builder();
            return this.addAllCoordinates(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllCoordinates(Iterable<? extends Geometry.LineString> elements) {
            for (Geometry.LineString lineString : elements) {
                ImmutableLineString immutableLineString = ImmutableLineString.copyOf(lineString);
                this.coordinates.add((Object)Objects.requireNonNull(immutableLineString, "coordinates element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder crs(EpsgCrs crs) {
            this.crs = Objects.requireNonNull(crs, "crs");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder crs(int code) {
            return this.crs(ImmutableEpsgCrs.of(code));
        }

        @JsonProperty(value="crs")
        @JsonIgnore
        @JacksonInject(value="filterCrs")
        @CanIgnoreReturnValue
        public final Builder crs(Optional<? extends EpsgCrs> crs) {
            this.crs = crs.orElse(null);
            return this;
        }

        public ImmutableMultiLineString build() {
            return new ImmutableMultiLineString((ImmutableList<Geometry.LineString>)this.coordinates.build(), this.crs);
        }
    }
}

