/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.cql.domain;

import de.ii.xtraplatform.cql.domain.Geometry;
import de.ii.xtraplatform.crs.domain.EpsgCrs;
import de.ii.xtraplatform.crs.domain.ImmutableEpsgCrs;
import java.util.Objects;
import java.util.Optional;
import shadow.com.fasterxml.jackson.annotation.JacksonInject;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Geometry.LineString", generator="Immutables")
@Immutable
public final class ImmutableLineString
implements Geometry.LineString {
    private final ImmutableList<Geometry.Coordinate> coordinates;
    @Nullable
    private final EpsgCrs crs;

    private ImmutableLineString(ImmutableList<Geometry.Coordinate> coordinates, @Nullable EpsgCrs crs) {
        this.coordinates = coordinates;
        this.crs = crs;
    }

    @Override
    @JsonProperty(value="coordinates")
    public ImmutableList<Geometry.Coordinate> getCoordinates() {
        return this.coordinates;
    }

    @Override
    @JsonProperty(value="crs")
    @JsonIgnore
    @JacksonInject(value="filterCrs")
    public Optional<EpsgCrs> getCrs() {
        return Optional.ofNullable(this.crs);
    }

    public final ImmutableLineString withCoordinates(Geometry.Coordinate ... elements) {
        ImmutableList<Geometry.Coordinate> newValue = ImmutableList.copyOf(elements);
        return new ImmutableLineString(newValue, this.crs);
    }

    public final ImmutableLineString withCoordinates(Iterable<? extends Geometry.Coordinate> elements) {
        if (this.coordinates == elements) {
            return this;
        }
        ImmutableList<Geometry.Coordinate> newValue = ImmutableList.copyOf(elements);
        return new ImmutableLineString(newValue, this.crs);
    }

    public final ImmutableLineString withCrs(EpsgCrs value) {
        EpsgCrs newValue = Objects.requireNonNull(value, "crs");
        if (this.crs == newValue) {
            return this;
        }
        return new ImmutableLineString(this.coordinates, newValue);
    }

    public final ImmutableLineString withCrs(Optional<? extends EpsgCrs> optional) {
        EpsgCrs value = optional.orElse(null);
        if (this.crs == value) {
            return this;
        }
        return new ImmutableLineString(this.coordinates, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLineString && this.equalTo((ImmutableLineString)another);
    }

    private boolean equalTo(ImmutableLineString another) {
        return this.coordinates.equals(another.coordinates) && Objects.equals(this.crs, another.crs);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.coordinates.hashCode();
        h += (h << 5) + Objects.hashCode(this.crs);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("LineString").omitNullValues().add("coordinates", this.coordinates).add("crs", this.crs).toString();
    }

    public static ImmutableLineString copyOf(Geometry.LineString instance) {
        if (instance instanceof ImmutableLineString) {
            return (ImmutableLineString)instance;
        }
        return new Builder().from(instance).build();
    }

    @Generated(from="Geometry.LineString", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private ImmutableList.Builder<Geometry.Coordinate> coordinates = ImmutableList.builder();
        @Nullable
        private EpsgCrs crs;

        @CanIgnoreReturnValue
        public final Builder from(Geometry.LineString instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllCoordinates(instance.getCoordinates());
            Optional<EpsgCrs> crsOptional = instance.getCrs();
            if (crsOptional.isPresent()) {
                this.crs(crsOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addCoordinates(Geometry.Coordinate element) {
            this.coordinates.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addCoordinates(Geometry.Coordinate ... elements) {
            this.coordinates.add(elements);
            return this;
        }

        @JsonProperty(value="coordinates")
        @CanIgnoreReturnValue
        public final Builder coordinates(Iterable<? extends Geometry.Coordinate> elements) {
            this.coordinates = ImmutableList.builder();
            return this.addAllCoordinates(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllCoordinates(Iterable<? extends Geometry.Coordinate> elements) {
            this.coordinates.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder crs(EpsgCrs crs) {
            this.crs = Objects.requireNonNull(crs, "crs");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder crs(int code) {
            return this.crs(ImmutableEpsgCrs.of(code));
        }

        @JsonProperty(value="crs")
        @JsonIgnore
        @JacksonInject(value="filterCrs")
        @CanIgnoreReturnValue
        public final Builder crs(Optional<? extends EpsgCrs> crs) {
            this.crs = crs.orElse(null);
            return this;
        }

        public ImmutableLineString build() {
            return new ImmutableLineString((ImmutableList<Geometry.Coordinate>)this.coordinates.build(), this.crs);
        }
    }
}

