/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.cql.domain;

import de.ii.xtraplatform.cql.domain.In;
import de.ii.xtraplatform.cql.domain.Scalar;
import java.util.Objects;
import java.util.Optional;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="In", generator="Immutables")
@Immutable
public final class ImmutableIn
implements In {
    @Nullable
    private final Scalar value;
    private final ImmutableList<Scalar> list;

    private ImmutableIn(@Nullable Scalar value, ImmutableList<Scalar> list) {
        this.value = value;
        this.list = list;
    }

    @Override
    @JsonProperty(value="value")
    public Optional<Scalar> getValue() {
        return Optional.ofNullable(this.value);
    }

    @JsonProperty(value="list")
    public ImmutableList<Scalar> getList() {
        return this.list;
    }

    public final ImmutableIn withValue(Scalar value) {
        Scalar newValue = Objects.requireNonNull(value, "value");
        if (this.value == newValue) {
            return this;
        }
        return ImmutableIn.validate(new ImmutableIn(newValue, this.list));
    }

    public final ImmutableIn withValue(Optional<? extends Scalar> optional) {
        Scalar value = optional.orElse(null);
        if (this.value == value) {
            return this;
        }
        return ImmutableIn.validate(new ImmutableIn(value, this.list));
    }

    public final ImmutableIn withList(Scalar ... elements) {
        ImmutableList<Scalar> newValue = ImmutableList.copyOf(elements);
        return ImmutableIn.validate(new ImmutableIn(this.value, newValue));
    }

    public final ImmutableIn withList(Iterable<? extends Scalar> elements) {
        if (this.list == elements) {
            return this;
        }
        ImmutableList<Scalar> newValue = ImmutableList.copyOf(elements);
        return ImmutableIn.validate(new ImmutableIn(this.value, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableIn && this.equalTo((ImmutableIn)another);
    }

    private boolean equalTo(ImmutableIn another) {
        return Objects.equals(this.value, another.value) && this.list.equals(another.list);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.value);
        h += (h << 5) + this.list.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("In").omitNullValues().add("value", this.value).add("list", this.list).toString();
    }

    private static ImmutableIn validate(ImmutableIn instance) {
        instance.check();
        return instance;
    }

    public static ImmutableIn copyOf(In instance) {
        if (instance instanceof ImmutableIn) {
            return (ImmutableIn)instance;
        }
        return new Builder().from(instance).build();
    }

    @Generated(from="In", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    extends In.Builder {
        @Nullable
        private Scalar value;
        private ImmutableList.Builder<Scalar> list = ImmutableList.builder();

        @CanIgnoreReturnValue
        public final Builder from(In instance) {
            Objects.requireNonNull(instance, "instance");
            Optional<Scalar> valueOptional = instance.getValue();
            if (valueOptional.isPresent()) {
                this.value(valueOptional);
            }
            this.addAllList(instance.getList());
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder value(Scalar value) {
            this.value = Objects.requireNonNull(value, "value");
            return this;
        }

        @JsonProperty(value="value")
        @CanIgnoreReturnValue
        public final Builder value(Optional<? extends Scalar> value) {
            this.value = value.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addList(Scalar element) {
            this.list.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addList(Scalar ... elements) {
            this.list.add(elements);
            return this;
        }

        @JsonProperty(value="list")
        @CanIgnoreReturnValue
        public final Builder list(Iterable<? extends Scalar> elements) {
            this.list = ImmutableList.builder();
            return this.addAllList(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllList(Iterable<? extends Scalar> elements) {
            this.list.addAll(elements);
            return this;
        }

        @Override
        public ImmutableIn build() {
            return ImmutableIn.validate(new ImmutableIn(this.value, (ImmutableList<Scalar>)this.list.build()));
        }
    }
}

