/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.cql.domain;

import de.ii.xtraplatform.cql.domain.Function;
import de.ii.xtraplatform.cql.domain.Operand;
import java.util.ArrayList;
import java.util.Objects;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Function", generator="Immutables")
@Immutable
public final class ImmutableFunction
implements Function {
    private final String name;
    private final ImmutableList<Operand> arguments;
    private volatile transient long lazyInitBitmap;
    private static final long TYPE_LAZY_INIT_BIT = 1L;
    private transient Class<?> type;
    private static final long IS_CASEI_LAZY_INIT_BIT = 2L;
    private transient boolean isCasei;
    private static final long IS_ACCENTI_LAZY_INIT_BIT = 4L;
    private transient boolean isAccenti;
    private static final long IS_LOWER_LAZY_INIT_BIT = 8L;
    private transient boolean isLower;
    private static final long IS_UPPER_LAZY_INIT_BIT = 16L;
    private transient boolean isUpper;
    private static final long IS_POSITION_LAZY_INIT_BIT = 32L;
    private transient boolean isPosition;
    private static final long IS_INTERVAL_LAZY_INIT_BIT = 64L;
    private transient boolean isInterval;

    private ImmutableFunction(String name, ImmutableList<Operand> arguments) {
        this.name = name;
        this.arguments = arguments;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="arguments")
    public ImmutableList<Operand> getArguments() {
        return this.arguments;
    }

    public final ImmutableFunction withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableFunction(newValue, this.arguments);
    }

    public final ImmutableFunction withArguments(Operand ... elements) {
        ImmutableList<Operand> newValue = ImmutableList.copyOf(elements);
        return new ImmutableFunction(this.name, newValue);
    }

    public final ImmutableFunction withArguments(Iterable<? extends Operand> elements) {
        if (this.arguments == elements) {
            return this;
        }
        ImmutableList<Operand> newValue = ImmutableList.copyOf(elements);
        return new ImmutableFunction(this.name, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFunction && this.equalTo((ImmutableFunction)another);
    }

    private boolean equalTo(ImmutableFunction another) {
        return this.name.equals(another.name) && this.arguments.equals(another.arguments);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.arguments.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("Function").omitNullValues().add("name", this.name).add("arguments", this.arguments).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> getType() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableFunction immutableFunction = this;
            synchronized (immutableFunction) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.type = Objects.requireNonNull(Function.super.getType(), "type");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCasei() {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            ImmutableFunction immutableFunction = this;
            synchronized (immutableFunction) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.isCasei = Function.super.isCasei();
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.isCasei;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAccenti() {
        if ((this.lazyInitBitmap & 4L) == 0L) {
            ImmutableFunction immutableFunction = this;
            synchronized (immutableFunction) {
                if ((this.lazyInitBitmap & 4L) == 0L) {
                    this.isAccenti = Function.super.isAccenti();
                    this.lazyInitBitmap |= 4L;
                }
            }
        }
        return this.isAccenti;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLower() {
        if ((this.lazyInitBitmap & 8L) == 0L) {
            ImmutableFunction immutableFunction = this;
            synchronized (immutableFunction) {
                if ((this.lazyInitBitmap & 8L) == 0L) {
                    this.isLower = Function.super.isLower();
                    this.lazyInitBitmap |= 8L;
                }
            }
        }
        return this.isLower;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUpper() {
        if ((this.lazyInitBitmap & 0x10L) == 0L) {
            ImmutableFunction immutableFunction = this;
            synchronized (immutableFunction) {
                if ((this.lazyInitBitmap & 0x10L) == 0L) {
                    this.isUpper = Function.super.isUpper();
                    this.lazyInitBitmap |= 0x10L;
                }
            }
        }
        return this.isUpper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPosition() {
        if ((this.lazyInitBitmap & 0x20L) == 0L) {
            ImmutableFunction immutableFunction = this;
            synchronized (immutableFunction) {
                if ((this.lazyInitBitmap & 0x20L) == 0L) {
                    this.isPosition = Function.super.isPosition();
                    this.lazyInitBitmap |= 0x20L;
                }
            }
        }
        return this.isPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInterval() {
        if ((this.lazyInitBitmap & 0x40L) == 0L) {
            ImmutableFunction immutableFunction = this;
            synchronized (immutableFunction) {
                if ((this.lazyInitBitmap & 0x40L) == 0L) {
                    this.isInterval = Function.super.isInterval();
                    this.lazyInitBitmap |= 0x40L;
                }
            }
        }
        return this.isInterval;
    }

    public static ImmutableFunction copyOf(Function instance) {
        if (instance instanceof ImmutableFunction) {
            return (ImmutableFunction)instance;
        }
        return new Builder().from(instance).build();
    }

    @Generated(from="Function", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        @Nullable
        private String name;
        private ImmutableList.Builder<Operand> arguments = ImmutableList.builder();

        @CanIgnoreReturnValue
        public final Builder from(Function instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.getName());
            this.addAllArguments(instance.getArguments());
            return this;
        }

        @JsonProperty(value="name")
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addArguments(Operand element) {
            this.arguments.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addArguments(Operand ... elements) {
            this.arguments.add(elements);
            return this;
        }

        @JsonProperty(value="arguments")
        @CanIgnoreReturnValue
        public final Builder arguments(Iterable<? extends Operand> elements) {
            this.arguments = ImmutableList.builder();
            return this.addAllArguments(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllArguments(Iterable<? extends Operand> elements) {
            this.arguments.addAll(elements);
            return this;
        }

        public ImmutableFunction build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFunction(this.name, (ImmutableList<Operand>)this.arguments.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build Function, some of required attributes are not set " + attributes;
        }
    }
}

