/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.cql.domain;

import de.ii.xtraplatform.cql.domain.Geometry;
import de.ii.xtraplatform.crs.domain.EpsgCrs;
import de.ii.xtraplatform.crs.domain.ImmutableEpsgCrs;
import java.util.Objects;
import java.util.Optional;
import shadow.com.fasterxml.jackson.annotation.JacksonInject;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.common.primitives.Doubles;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Geometry.Envelope", generator="Immutables")
@Immutable
public final class ImmutableEnvelope
implements Geometry.Envelope {
    @Nullable
    private final EpsgCrs crs;
    private final ImmutableList<Double> coordinates;

    private ImmutableEnvelope(@Nullable EpsgCrs crs, ImmutableList<Double> coordinates) {
        this.crs = crs;
        this.coordinates = coordinates;
    }

    @Override
    @JsonProperty(value="crs")
    @JsonIgnore
    @JacksonInject(value="filterCrs")
    public Optional<EpsgCrs> getCrs() {
        return Optional.ofNullable(this.crs);
    }

    @Override
    @JsonProperty(value="bbox")
    public ImmutableList<Double> getCoordinates() {
        return this.coordinates;
    }

    public final ImmutableEnvelope withCrs(EpsgCrs value) {
        EpsgCrs newValue = Objects.requireNonNull(value, "crs");
        if (this.crs == newValue) {
            return this;
        }
        return new ImmutableEnvelope(newValue, this.coordinates);
    }

    public final ImmutableEnvelope withCrs(Optional<? extends EpsgCrs> optional) {
        EpsgCrs value = optional.orElse(null);
        if (this.crs == value) {
            return this;
        }
        return new ImmutableEnvelope(value, this.coordinates);
    }

    public final ImmutableEnvelope withCoordinates(double ... elements) {
        ImmutableList<Double> newValue = ImmutableList.copyOf(Doubles.asList(elements));
        return new ImmutableEnvelope(this.crs, newValue);
    }

    public final ImmutableEnvelope withCoordinates(Iterable<Double> elements) {
        if (this.coordinates == elements) {
            return this;
        }
        ImmutableList<Double> newValue = ImmutableList.copyOf(elements);
        return new ImmutableEnvelope(this.crs, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEnvelope && this.equalTo((ImmutableEnvelope)another);
    }

    private boolean equalTo(ImmutableEnvelope another) {
        return Objects.equals(this.crs, another.crs) && this.coordinates.equals(another.coordinates);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.crs);
        h += (h << 5) + this.coordinates.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("Envelope").omitNullValues().add("crs", this.crs).add("coordinates", this.coordinates).toString();
    }

    public static ImmutableEnvelope copyOf(Geometry.Envelope instance) {
        if (instance instanceof ImmutableEnvelope) {
            return (ImmutableEnvelope)instance;
        }
        return new Builder().from(instance).build();
    }

    @Generated(from="Geometry.Envelope", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private EpsgCrs crs;
        private ImmutableList.Builder<Double> coordinates = ImmutableList.builder();

        @CanIgnoreReturnValue
        public final Builder from(Geometry.Envelope instance) {
            Objects.requireNonNull(instance, "instance");
            Optional<EpsgCrs> crsOptional = instance.getCrs();
            if (crsOptional.isPresent()) {
                this.crs(crsOptional);
            }
            this.addAllCoordinates(instance.getCoordinates());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder crs(EpsgCrs crs) {
            this.crs = Objects.requireNonNull(crs, "crs");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder crs(int code) {
            return this.crs(ImmutableEpsgCrs.of(code));
        }

        @JsonProperty(value="crs")
        @JsonIgnore
        @JacksonInject(value="filterCrs")
        @CanIgnoreReturnValue
        public final Builder crs(Optional<? extends EpsgCrs> crs) {
            this.crs = crs.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addCoordinates(double element) {
            this.coordinates.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addCoordinates(double ... elements) {
            this.coordinates.addAll(Doubles.asList(elements));
            return this;
        }

        @JsonProperty(value="bbox")
        @CanIgnoreReturnValue
        public final Builder coordinates(Iterable<Double> elements) {
            this.coordinates = ImmutableList.builder();
            return this.addAllCoordinates(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllCoordinates(Iterable<Double> elements) {
            this.coordinates.addAll((Iterable)elements);
            return this;
        }

        public ImmutableEnvelope build() {
            return new ImmutableEnvelope(this.crs, (ImmutableList<Double>)this.coordinates.build());
        }
    }
}

