/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.cql.domain;

import de.ii.xtraplatform.cql.domain.Between;
import de.ii.xtraplatform.cql.domain.Operand;
import de.ii.xtraplatform.cql.domain.Scalar;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Between", generator="Immutables")
@Immutable
public final class ImmutableBetween
implements Between {
    @Nullable
    private final Scalar value;
    @Nullable
    private final Scalar lower;
    @Nullable
    private final Scalar upper;
    private final transient List<Operand> operands;

    private ImmutableBetween(@Nullable Scalar value, @Nullable Scalar lower, @Nullable Scalar upper) {
        this.value = value;
        this.lower = lower;
        this.upper = upper;
        this.operands = Objects.requireNonNull(Between.super.getOperands(), "operands");
    }

    @Override
    @JsonProperty(value="value")
    public Optional<Scalar> getValue() {
        return Optional.ofNullable(this.value);
    }

    @Override
    @JsonProperty(value="lower")
    public Optional<Scalar> getLower() {
        return Optional.ofNullable(this.lower);
    }

    @Override
    @JsonProperty(value="upper")
    public Optional<Scalar> getUpper() {
        return Optional.ofNullable(this.upper);
    }

    @Override
    @JsonProperty(value="operands")
    @JsonIgnore
    public List<Operand> getOperands() {
        return this.operands;
    }

    public final ImmutableBetween withValue(Scalar value) {
        Scalar newValue = Objects.requireNonNull(value, "value");
        if (this.value == newValue) {
            return this;
        }
        return ImmutableBetween.validate(new ImmutableBetween(newValue, this.lower, this.upper));
    }

    public final ImmutableBetween withValue(Optional<? extends Scalar> optional) {
        Scalar value = optional.orElse(null);
        if (this.value == value) {
            return this;
        }
        return ImmutableBetween.validate(new ImmutableBetween(value, this.lower, this.upper));
    }

    public final ImmutableBetween withLower(Scalar value) {
        Scalar newValue = Objects.requireNonNull(value, "lower");
        if (this.lower == newValue) {
            return this;
        }
        return ImmutableBetween.validate(new ImmutableBetween(this.value, newValue, this.upper));
    }

    public final ImmutableBetween withLower(Optional<? extends Scalar> optional) {
        Scalar value = optional.orElse(null);
        if (this.lower == value) {
            return this;
        }
        return ImmutableBetween.validate(new ImmutableBetween(this.value, value, this.upper));
    }

    public final ImmutableBetween withUpper(Scalar value) {
        Scalar newValue = Objects.requireNonNull(value, "upper");
        if (this.upper == newValue) {
            return this;
        }
        return ImmutableBetween.validate(new ImmutableBetween(this.value, this.lower, newValue));
    }

    public final ImmutableBetween withUpper(Optional<? extends Scalar> optional) {
        Scalar value = optional.orElse(null);
        if (this.upper == value) {
            return this;
        }
        return ImmutableBetween.validate(new ImmutableBetween(this.value, this.lower, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBetween && this.equalTo((ImmutableBetween)another);
    }

    private boolean equalTo(ImmutableBetween another) {
        return Objects.equals(this.value, another.value) && Objects.equals(this.lower, another.lower) && Objects.equals(this.upper, another.upper);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.value);
        h += (h << 5) + Objects.hashCode(this.lower);
        h += (h << 5) + Objects.hashCode(this.upper);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("Between").omitNullValues().add("value", this.value).add("lower", this.lower).add("upper", this.upper).toString();
    }

    private static ImmutableBetween validate(ImmutableBetween instance) {
        instance.check();
        return instance;
    }

    public static ImmutableBetween copyOf(Between instance) {
        if (instance instanceof ImmutableBetween) {
            return (ImmutableBetween)instance;
        }
        return new Builder().from(instance).build();
    }

    @Generated(from="Between", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    extends Between.Builder {
        @Nullable
        private Scalar value;
        @Nullable
        private Scalar lower;
        @Nullable
        private Scalar upper;

        @CanIgnoreReturnValue
        public final Builder from(Between instance) {
            Optional<Scalar> upperOptional;
            Optional<Scalar> lowerOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<Scalar> valueOptional = instance.getValue();
            if (valueOptional.isPresent()) {
                this.value(valueOptional);
            }
            if ((lowerOptional = instance.getLower()).isPresent()) {
                this.lower(lowerOptional);
            }
            if ((upperOptional = instance.getUpper()).isPresent()) {
                this.upper(upperOptional);
            }
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder value(Scalar value) {
            this.value = Objects.requireNonNull(value, "value");
            return this;
        }

        @JsonProperty(value="value")
        @CanIgnoreReturnValue
        public final Builder value(Optional<? extends Scalar> value) {
            this.value = value.orElse(null);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder lower(Scalar lower) {
            this.lower = Objects.requireNonNull(lower, "lower");
            return this;
        }

        @JsonProperty(value="lower")
        @CanIgnoreReturnValue
        public final Builder lower(Optional<? extends Scalar> lower) {
            this.lower = lower.orElse(null);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder upper(Scalar upper) {
            this.upper = Objects.requireNonNull(upper, "upper");
            return this;
        }

        @JsonProperty(value="upper")
        @CanIgnoreReturnValue
        public final Builder upper(Optional<? extends Scalar> upper) {
            this.upper = upper.orElse(null);
            return this;
        }

        @Override
        public ImmutableBetween build() {
            return ImmutableBetween.validate(new ImmutableBetween(this.value, this.lower, this.upper));
        }
    }
}

