/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.cql.domain;

import de.ii.xtraplatform.cql.domain.CqlNode;
import de.ii.xtraplatform.cql.domain.ImmutableEnvelope;
import de.ii.xtraplatform.cql.domain.ImmutableLineString;
import de.ii.xtraplatform.cql.domain.ImmutableMultiLineString;
import de.ii.xtraplatform.cql.domain.ImmutableMultiPoint;
import de.ii.xtraplatform.cql.domain.ImmutableMultiPolygon;
import de.ii.xtraplatform.cql.domain.ImmutablePoint;
import de.ii.xtraplatform.cql.domain.ImmutablePolygon;
import de.ii.xtraplatform.crs.domain.BoundingBox;
import de.ii.xtraplatform.crs.domain.EpsgCrs;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import shadow.com.fasterxml.jackson.annotation.JacksonInject;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.fasterxml.jackson.annotation.JsonSubTypes;
import shadow.com.fasterxml.jackson.annotation.JsonTypeInfo;
import shadow.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.com.google.common.base.Preconditions;
import shadow.org.immutables.value.Value;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type", defaultImpl=Envelope.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=Point.class, name="Point"), @JsonSubTypes.Type(value=LineString.class, name="LineString"), @JsonSubTypes.Type(value=Polygon.class, name="Polygon"), @JsonSubTypes.Type(value=MultiPoint.class, name="MultiPoint"), @JsonSubTypes.Type(value=MultiLineString.class, name="MultiLineString"), @JsonSubTypes.Type(value=MultiPolygon.class, name="MultiPolygon")})
public interface Geometry<T>
extends CqlNode {
    public Type getType();

    public List<T> getCoordinates();

    @JsonIgnore
    @JacksonInject(value="filterCrs")
    public Optional<EpsgCrs> getCrs();

    public static class Coordinate
    extends ArrayList<Double>
    implements CqlNode {
        public static Coordinate of(double x, double y) {
            return new Coordinate(x, y);
        }

        static Coordinate of(double x, double y, double z) {
            return new Coordinate(x, y, z);
        }

        public Coordinate(Double x, Double y) {
            this.add(x);
            this.add(y);
        }

        public Coordinate(Double x, Double y, Double z) {
            this(x, y);
            this.add(z);
        }

        public Coordinate() {
        }
    }

    @JsonDeserialize(builder=ImmutableEnvelope.Builder.class)
    @Value.Immutable
    public static interface Envelope
    extends Geometry<Double> {
        public static Envelope of(BoundingBox boundingBox) {
            return new ImmutableEnvelope.Builder().addCoordinates(boundingBox.getXmin(), boundingBox.getYmin(), boundingBox.getXmax(), boundingBox.getYmax()).crs(boundingBox.getEpsgCrs()).build();
        }

        public static Envelope of(double xmin, double ymin, double xmax, double ymax) {
            return new ImmutableEnvelope.Builder().addCoordinates(xmin, ymin, xmax, ymax).build();
        }

        public static Envelope of(double xmin, double ymin, double xmax, double ymax, EpsgCrs crs) {
            return new ImmutableEnvelope.Builder().addCoordinates(xmin, ymin, xmax, ymax).crs(crs).build();
        }

        @Override
        @JsonIgnore
        default public Type getType() {
            return Type.Envelope;
        }

        @Override
        @JsonProperty(value="bbox")
        public List<Double> getCoordinates();
    }

    @JsonDeserialize(builder=ImmutableMultiPolygon.Builder.class)
    @Value.Immutable
    public static interface MultiPolygon
    extends Geometry<Polygon> {
        public static MultiPolygon of(Polygon ... polygons) {
            return new ImmutableMultiPolygon.Builder().addCoordinates(polygons).build();
        }

        @Override
        default public Type getType() {
            return Type.MultiPolygon;
        }
    }

    @JsonDeserialize(builder=ImmutableMultiLineString.Builder.class)
    @Value.Immutable
    public static interface MultiLineString
    extends Geometry<LineString> {
        public static MultiLineString of(LineString ... lineStrings) {
            return new ImmutableMultiLineString.Builder().addCoordinates(lineStrings).build();
        }

        @Override
        default public Type getType() {
            return Type.MultiLineString;
        }
    }

    @JsonDeserialize(builder=ImmutableMultiPoint.Builder.class)
    @Value.Immutable
    public static interface MultiPoint
    extends Geometry<Point> {
        public static MultiPoint of(Point ... points) {
            return new ImmutableMultiPoint.Builder().addCoordinates(points).build();
        }

        @Override
        default public Type getType() {
            return Type.MultiPoint;
        }
    }

    @JsonDeserialize(builder=ImmutablePolygon.Builder.class)
    @Value.Immutable
    public static interface Polygon
    extends Geometry<List<Coordinate>> {
        public static Polygon of(List<Coordinate> ... coordinates) {
            return new ImmutablePolygon.Builder().addCoordinates(coordinates).build();
        }

        public static Polygon of(EpsgCrs crs, List<Coordinate> ... coordinates) {
            return new ImmutablePolygon.Builder().crs(crs).addCoordinates(coordinates).build();
        }

        @Override
        default public Type getType() {
            return Type.Polygon;
        }
    }

    @JsonDeserialize(builder=ImmutableLineString.Builder.class)
    @Value.Immutable
    public static interface LineString
    extends Geometry<Coordinate> {
        public static LineString of(Coordinate ... coordinates) {
            return new ImmutableLineString.Builder().addCoordinates(coordinates).build();
        }

        @Override
        default public Type getType() {
            return Type.LineString;
        }
    }

    @JsonDeserialize(builder=ImmutablePoint.Builder.class)
    @Value.Immutable
    public static interface Point
    extends Geometry<Coordinate> {
        public static Point of(double x, double y) {
            return new ImmutablePoint.Builder().addCoordinates(Coordinate.of(x, y)).build();
        }

        public static Point of(double x, double y, EpsgCrs crs) {
            return new ImmutablePoint.Builder().addCoordinates(Coordinate.of(x, y)).crs(crs).build();
        }

        public static Point of(Coordinate coordinate) {
            return new ImmutablePoint.Builder().addCoordinates(coordinate).build();
        }

        @Value.Check
        default public void check() {
            Preconditions.checkState(this.getCoordinates().size() == 1, "a point must have only one coordinate", this.getCoordinates().size());
        }

        @Override
        default public Type getType() {
            return Type.Point;
        }
    }

    public static enum Type {
        Point,
        LineString,
        Polygon,
        MultiPoint,
        MultiLineString,
        MultiPolygon,
        Envelope;

    }
}

