/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.cql.domain;

import de.ii.xtraplatform.cql.domain.CqlNode;
import de.ii.xtraplatform.cql.domain.CqlVisitor;
import de.ii.xtraplatform.cql.domain.ImmutableFunction;
import de.ii.xtraplatform.cql.domain.Operand;
import de.ii.xtraplatform.cql.domain.Scalar;
import de.ii.xtraplatform.cql.domain.ScalarLiteral;
import de.ii.xtraplatform.cql.domain.Temporal;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import shadow.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.core.JsonGenerator;
import shadow.com.fasterxml.jackson.databind.SerializerProvider;
import shadow.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import shadow.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import shadow.org.immutables.value.Value;
import shadow.org.threeten.extra.Interval;

@JsonDeserialize(builder=ImmutableFunction.Builder.class)
@JsonSerialize(using=FunctionSerializer.class)
@Value.Immutable
public interface Function
extends CqlNode,
Scalar,
Temporal,
Operand {
    public String getName();

    public List<Operand> getArguments();

    @JsonCreator
    public static Function of(String name, List<Operand> arguments) {
        return new ImmutableFunction.Builder().name(name).arguments(arguments).build();
    }

    default public <U> U accept(CqlVisitor<U> visitor) {
        List arguments = this.getArguments().stream().map(argument -> argument.accept(visitor)).collect(Collectors.toList());
        return visitor.visit(this, arguments);
    }

    @JsonIgnore
    @Value.Lazy
    default public Class<?> getType() {
        if (this.isAccenti() || this.isCasei() || this.isLower() || this.isUpper()) {
            return String.class;
        }
        if (this.isInterval()) {
            return Interval.class;
        }
        if (this.isPosition()) {
            return Integer.class;
        }
        return Object.class;
    }

    @JsonIgnore
    @Value.Lazy
    default public boolean isCasei() {
        return "casei".equalsIgnoreCase(this.getName());
    }

    @JsonIgnore
    @Value.Lazy
    default public boolean isAccenti() {
        return "accenti".equalsIgnoreCase(this.getName());
    }

    @JsonIgnore
    @Value.Lazy
    default public boolean isLower() {
        return "lower".equalsIgnoreCase(this.getName());
    }

    @JsonIgnore
    @Value.Lazy
    default public boolean isUpper() {
        return "upper".equalsIgnoreCase(this.getName());
    }

    @JsonIgnore
    @Value.Lazy
    default public boolean isPosition() {
        return "position".equalsIgnoreCase(this.getName());
    }

    @JsonIgnore
    @Value.Lazy
    default public boolean isInterval() {
        return "interval".equalsIgnoreCase(this.getName());
    }

    public static class FunctionSerializer
    extends StdSerializer<Function> {
        protected FunctionSerializer() {
            this((Class<Function>)null);
        }

        protected FunctionSerializer(Class<Function> t) {
            super(t);
        }

        @Override
        public void serialize(Function value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeStartObject();
            gen.writeFieldName("function");
            gen.writeStartObject();
            gen.writeStringField("name", value.getName());
            gen.writeFieldName("arguments");
            gen.writeStartArray();
            for (Operand operand : value.getArguments()) {
                if (operand instanceof ScalarLiteral) {
                    gen.writeString(String.format("%s", ((ScalarLiteral)operand).getValue().toString()));
                    continue;
                }
                gen.writeObject(operand);
            }
            gen.writeEndArray();
            gen.writeEndObject();
            gen.writeEndObject();
        }
    }
}

