/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.cql.domain;

import de.ii.xtraplatform.cql.domain.And;
import de.ii.xtraplatform.cql.domain.ArrayLiteral;
import de.ii.xtraplatform.cql.domain.ArrayOperation;
import de.ii.xtraplatform.cql.domain.Between;
import de.ii.xtraplatform.cql.domain.BinaryScalarOperation;
import de.ii.xtraplatform.cql.domain.CqlFilter;
import de.ii.xtraplatform.cql.domain.CqlNode;
import de.ii.xtraplatform.cql.domain.CqlPredicate;
import de.ii.xtraplatform.cql.domain.CqlVisitor;
import de.ii.xtraplatform.cql.domain.Function;
import de.ii.xtraplatform.cql.domain.Geometry;
import de.ii.xtraplatform.cql.domain.ImmutableAnd;
import de.ii.xtraplatform.cql.domain.ImmutableBetween;
import de.ii.xtraplatform.cql.domain.ImmutableEq;
import de.ii.xtraplatform.cql.domain.ImmutableGt;
import de.ii.xtraplatform.cql.domain.ImmutableGte;
import de.ii.xtraplatform.cql.domain.ImmutableIn;
import de.ii.xtraplatform.cql.domain.ImmutableIsNull;
import de.ii.xtraplatform.cql.domain.ImmutableLike;
import de.ii.xtraplatform.cql.domain.ImmutableLt;
import de.ii.xtraplatform.cql.domain.ImmutableLte;
import de.ii.xtraplatform.cql.domain.ImmutableNeq;
import de.ii.xtraplatform.cql.domain.ImmutableNot;
import de.ii.xtraplatform.cql.domain.ImmutableOr;
import de.ii.xtraplatform.cql.domain.In;
import de.ii.xtraplatform.cql.domain.IsNull;
import de.ii.xtraplatform.cql.domain.Like;
import de.ii.xtraplatform.cql.domain.LogicalOperation;
import de.ii.xtraplatform.cql.domain.Not;
import de.ii.xtraplatform.cql.domain.Or;
import de.ii.xtraplatform.cql.domain.Property;
import de.ii.xtraplatform.cql.domain.ScalarLiteral;
import de.ii.xtraplatform.cql.domain.SpatialLiteral;
import de.ii.xtraplatform.cql.domain.SpatialOperation;
import de.ii.xtraplatform.cql.domain.TemporalLiteral;
import de.ii.xtraplatform.cql.domain.TemporalOperation;
import de.ii.xtraplatform.crs.domain.EpsgCrs;
import java.time.Instant;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import shadow.com.google.common.collect.ImmutableMap;
import shadow.org.threeten.extra.Interval;

public class CqlToText
implements CqlVisitor<String> {
    protected static final Map<Class<?>, String> LOGICAL_OPERATORS = new ImmutableMap.Builder<Class<ImmutableAnd>, String>().put(ImmutableAnd.class, "AND").put(ImmutableOr.class, "OR").put(ImmutableNot.class, "NOT").build();
    protected static final Map<Class<?>, String> SCALAR_OPERATORS = new ImmutableMap.Builder<Class<ImmutableEq>, String>().put(ImmutableEq.class, "=").put(ImmutableNeq.class, "<>").put(ImmutableGt.class, ">").put(ImmutableGte.class, ">=").put(ImmutableLt.class, "<").put(ImmutableLte.class, "<=").put(ImmutableLike.class, "LIKE").put(ImmutableBetween.class, "BETWEEN").put(ImmutableIn.class, "IN").put(ImmutableIsNull.class, "IS NULL").build();
    private final Optional<BiFunction<List<Double>, Optional<EpsgCrs>, List<Double>>> coordinatesTransformer;

    public CqlToText() {
        this.coordinatesTransformer = Optional.empty();
    }

    public CqlToText(BiFunction<List<Double>, Optional<EpsgCrs>, List<Double>> coordinatesTransformer) {
        this.coordinatesTransformer = Optional.ofNullable(coordinatesTransformer);
    }

    private java.util.function.Function<Geometry.Coordinate, Geometry.Coordinate> transformIfNecessary(Optional<EpsgCrs> sourceCrs) {
        return coordinate -> this.coordinatesTransformer.map(transformer -> (List)transformer.apply(coordinate, sourceCrs)).map(list -> Geometry.Coordinate.of((Double)list.get(0), (Double)list.get(1))).orElse((Geometry.Coordinate)coordinate);
    }

    private java.util.function.Function<List<Double>, List<Double>> transformIfNecessary2(Optional<EpsgCrs> sourceCrs) {
        return coordinates -> this.coordinatesTransformer.map(transformer -> (List)transformer.apply(coordinates, sourceCrs)).orElse((List)coordinates);
    }

    @Override
    public String visit(CqlFilter cqlFilter, List<String> children) {
        CqlNode node = cqlFilter.getExpressions().get(0);
        String text = node.accept(this);
        if (node instanceof And || node instanceof Or) {
            return text.substring(1, text.length() - 1);
        }
        return text;
    }

    @Override
    public String visit(CqlPredicate cqlPredicate, List<String> children) {
        return cqlPredicate.getExpressions().get(0).accept(this);
    }

    @Override
    public String visit(LogicalOperation logicalOperation, List<String> children) {
        String operator = LOGICAL_OPERATORS.get(logicalOperation.getClass());
        return children.stream().collect(Collectors.joining(String.format(" %s ", operator), "(", ")"));
    }

    @Override
    public String visit(Not not, List<String> children) {
        String operator = LOGICAL_OPERATORS.get(not.getClass());
        String operation = children.get(0);
        if (not.getPredicate().get().getLike().isPresent()) {
            String like = SCALAR_OPERATORS.get(ImmutableLike.class);
            return operation.replace(like, String.format("%s %s", operator, like));
        }
        if (not.getPredicate().get().getIsNull().isPresent()) {
            String isNull = SCALAR_OPERATORS.get(ImmutableIsNull.class);
            return operation.replace(isNull, "IS NOT NULL");
        }
        if (not.getPredicate().get().getBetween().isPresent()) {
            String between = SCALAR_OPERATORS.get(ImmutableBetween.class);
            return operation.replace(between, String.format("%s %s", operator, between));
        }
        if (not.getPredicate().get().getInOperator().isPresent()) {
            String in = SCALAR_OPERATORS.get(ImmutableIn.class);
            return operation.replace(in, String.format("%s %s", operator, in));
        }
        return String.format("NOT (%s)", operation);
    }

    @Override
    public String visit(BinaryScalarOperation scalarOperation, List<String> children) {
        String operator = SCALAR_OPERATORS.get(scalarOperation.getClass());
        return String.format("%s %s %s", children.get(0), operator, children.get(1));
    }

    @Override
    public String visit(Between between, List<String> children) {
        String operator = SCALAR_OPERATORS.get(between.getClass());
        return String.format("%s %s %s AND %s", children.get(0), operator, children.get(1), children.get(2));
    }

    @Override
    public String visit(Like like, List<String> children) {
        String operator = SCALAR_OPERATORS.get(like.getClass());
        return String.format("%s %s %s", children.get(0), operator, children.get(1)).trim().replace("  ", " ");
    }

    @Override
    public String visit(In in, List<String> children) {
        String operator = SCALAR_OPERATORS.get(in.getClass());
        String property = Objects.equals(children.get(0), "_ID_") ? "" : children.get(0);
        return String.format("%s %s (%s)", property, operator, String.join((CharSequence)", ", children.subList(1, children.size())));
    }

    @Override
    public String visit(IsNull isNull, List<String> children) {
        String operator = SCALAR_OPERATORS.get(isNull.getClass());
        return String.format("%s %s", children.get(0), operator);
    }

    @Override
    public String visit(TemporalOperation temporalOperation, List<String> children) {
        String operator = temporalOperation.getOperator().toString();
        return String.format("%s(%s, %s)", operator, children.get(0), children.get(1));
    }

    @Override
    public String visit(SpatialOperation spatialOperation, List<String> children) {
        String operator = spatialOperation.getOperator().toString();
        return String.format("%s(%s, %s)", operator, children.get(0), children.get(1));
    }

    @Override
    public String visit(ArrayOperation arrayOperation, List<String> children) {
        String operator = arrayOperation.getOperator().toString();
        return String.format("%s(%s, %s)", operator, children.get(0), children.get(1));
    }

    @Override
    public String visit(Geometry.Coordinate coordinate, List<String> children) {
        return coordinate.stream().map(Object::toString).collect(Collectors.joining(" "));
    }

    @Override
    public String visit(Geometry.Point point, List<String> children) {
        return String.format("POINT(%s)", this.transformIfNecessary(point.getCrs()).apply((Geometry.Coordinate)point.getCoordinates().get(0)).accept(this));
    }

    @Override
    public String visit(Geometry.LineString lineString, List<String> children) {
        return String.format("LINESTRING%s", lineString.getCoordinates().stream().map(this.transformIfNecessary(lineString.getCrs())).map(coordinate -> coordinate.accept(this)).collect(Collectors.joining(",", "(", ")")));
    }

    @Override
    public String visit(Geometry.Polygon polygon, List<String> children) {
        return String.format("POLYGON%s", polygon.getCoordinates().stream().flatMap(l -> Stream.of(l.stream().map(this.transformIfNecessary(polygon.getCrs())).flatMap(coordinate -> Stream.of(coordinate.accept(this))).collect(Collectors.joining(",", "(", ")")))).collect(Collectors.joining(",", "(", ")")));
    }

    @Override
    public String visit(Geometry.MultiPoint multiPoint, List<String> children) {
        return String.format("MULTIPOINT%s", multiPoint.getCoordinates().stream().flatMap(point -> point.getCoordinates().stream()).map(this.transformIfNecessary(multiPoint.getCrs())).map(coordinate -> coordinate.accept(this)).collect(Collectors.joining(",", "(", ")")));
    }

    @Override
    public String visit(Geometry.MultiLineString multiLineString, List<String> children) {
        return String.format("MULTILINESTRING%s", multiLineString.getCoordinates().stream().flatMap(ls -> Stream.of(ls.getCoordinates().stream().map(this.transformIfNecessary(multiLineString.getCrs())).map(coordinate -> coordinate.accept(this)).collect(Collectors.joining(",", "(", ")")))).collect(Collectors.joining(",", "(", ")")));
    }

    @Override
    public String visit(Geometry.MultiPolygon multiPolygon, List<String> children) {
        return String.format("MULTIPOLYGON%s", multiPolygon.getCoordinates().stream().flatMap(p -> Stream.of(p.getCoordinates().stream().flatMap(l -> Stream.of(l.stream().map(this.transformIfNecessary(multiPolygon.getCrs())).flatMap(coordinate -> Stream.of(coordinate.accept(this))).collect(Collectors.joining(",", "(", ")")))).collect(Collectors.joining(",", "(", ")")))).collect(Collectors.joining(",", "(", ")")));
    }

    @Override
    public String visit(Geometry.Envelope envelope, List<String> children) {
        return String.format("ENVELOPE%s", this.transformIfNecessary2(envelope.getCrs()).apply(envelope.getCoordinates()).stream().map(String::valueOf).collect(Collectors.joining(",", "(", ")")));
    }

    @Override
    public String visit(ScalarLiteral scalarLiteral, List<String> children) {
        if (scalarLiteral.getType() == String.class) {
            return String.format("'%s'", ((String)scalarLiteral.getValue()).replaceAll("'", "''"));
        }
        return scalarLiteral.getValue().toString();
    }

    @Override
    public String visit(TemporalLiteral temporalLiteral, List<String> children) {
        if (temporalLiteral.getType() == Interval.class) {
            Interval interval = (Interval)temporalLiteral.getValue();
            String start = interval.getStart().equals(Instant.MIN) ? ".." : DateTimeFormatter.ISO_INSTANT.format(interval.getStart());
            String end = interval.getEnd().equals(Instant.MAX) ? ".." : DateTimeFormatter.ISO_INSTANT.format(interval.getEnd().minusSeconds(1L));
            return String.format("INTERVAL('%s','%s')", start, end);
        }
        if (temporalLiteral.getType() == Instant.class) {
            Instant instant = (Instant)temporalLiteral.getValue();
            if (instant == Instant.MIN || instant == Instant.MAX) {
                return "'..'";
            }
            return String.format("TIMESTAMP('%s')", DateTimeFormatter.ISO_INSTANT.format(instant));
        }
        if (temporalLiteral.getType() == LocalDate.class) {
            return String.format("DATE('%s')", DateTimeFormatter.ISO_DATE.format((LocalDate)temporalLiteral.getValue()));
        }
        if (temporalLiteral.getType() == Function.class) {
            Function function = (Function)temporalLiteral.getValue();
            return String.format("%s(%s)", function.getName(), function.getArguments().stream().map(arg -> arg.accept(this).replace("DATE(", "").replace("TIMESTAMP(", "").replace(")", "")).collect(Collectors.joining(",")));
        }
        throw new IllegalStateException("unsupported temporal literal type: " + temporalLiteral.getType().getSimpleName());
    }

    @Override
    public String visit(ArrayLiteral arrayLiteral, List<String> children) {
        if (arrayLiteral.getValue() instanceof String) {
            return (String)arrayLiteral.getValue();
        }
        List elements = ((List)arrayLiteral.getValue()).stream().map(e -> e.accept(this)).map(e -> String.format("%s", e)).collect(Collectors.toList());
        return String.format("[%s]", String.join((CharSequence)",", elements));
    }

    @Override
    public String visit(SpatialLiteral spatialLiteral, List<String> children) {
        return ((CqlNode)spatialLiteral.getValue()).accept(this);
    }

    @Override
    public String visit(Property property, List<String> children) {
        if (!property.getNestedFilters().isEmpty()) {
            Map<String, CqlFilter> nestedFilters = property.getNestedFilters();
            StringJoiner sj = new StringJoiner(".");
            for (String element : property.getPath()) {
                if (nestedFilters.containsKey(element)) {
                    sj.add(String.format("%s[%s]", element, nestedFilters.get(element).accept(this)));
                    continue;
                }
                sj.add(element);
            }
            return sj.toString();
        }
        return property.getPath().get(property.getPath().size() - 1);
    }

    @Override
    public String visit(Function function, List<String> children) {
        return function.getName() + function.getArguments().stream().map(argument -> argument.accept(this)).collect(Collectors.joining(",", "(", ")"));
    }
}

