/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.cql.domain;

import de.ii.xtraplatform.cql.domain.And;
import de.ii.xtraplatform.cql.domain.ArrayExpression;
import de.ii.xtraplatform.cql.domain.ArrayOperation;
import de.ii.xtraplatform.cql.domain.Between;
import de.ii.xtraplatform.cql.domain.CqlNode;
import de.ii.xtraplatform.cql.domain.CqlVisitor;
import de.ii.xtraplatform.cql.domain.Eq;
import de.ii.xtraplatform.cql.domain.Gt;
import de.ii.xtraplatform.cql.domain.Gte;
import de.ii.xtraplatform.cql.domain.ImmutableCqlPredicate;
import de.ii.xtraplatform.cql.domain.In;
import de.ii.xtraplatform.cql.domain.IsNull;
import de.ii.xtraplatform.cql.domain.Like;
import de.ii.xtraplatform.cql.domain.LogicalExpression;
import de.ii.xtraplatform.cql.domain.Lt;
import de.ii.xtraplatform.cql.domain.Lte;
import de.ii.xtraplatform.cql.domain.Neq;
import de.ii.xtraplatform.cql.domain.Not;
import de.ii.xtraplatform.cql.domain.Or;
import de.ii.xtraplatform.cql.domain.ScalarExpression;
import de.ii.xtraplatform.cql.domain.SpatialExpression;
import de.ii.xtraplatform.cql.domain.SpatialOperation;
import de.ii.xtraplatform.cql.domain.TemporalExpression;
import de.ii.xtraplatform.cql.domain.TemporalOperation;
import java.util.List;
import java.util.Optional;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.com.google.common.base.Preconditions;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.common.collect.Lists;
import shadow.org.immutables.value.Value;

@JsonDeserialize(builder=ImmutableCqlPredicate.Builder.class)
@Value.Immutable
public interface CqlPredicate
extends LogicalExpression,
ScalarExpression,
SpatialExpression,
TemporalExpression,
ArrayExpression,
CqlNode {
    public static CqlPredicate of(CqlNode node) {
        ImmutableCqlPredicate.Builder builder = new ImmutableCqlPredicate.Builder();
        if (node instanceof And) {
            builder.and((And)node);
        } else if (node instanceof Or) {
            builder.or((Or)node);
        } else if (node instanceof Not) {
            builder.not((Not)node);
        } else if (node instanceof Eq) {
            builder.eq((Eq)node);
        } else if (node instanceof Neq) {
            builder.neq((Neq)node);
        } else if (node instanceof Gt) {
            builder.gt((Gt)node);
        } else if (node instanceof Gte) {
            builder.gte((Gte)node);
        } else if (node instanceof Lt) {
            builder.lt((Lt)node);
        } else if (node instanceof Lte) {
            builder.lte((Lte)node);
        } else if (node instanceof Between) {
            builder.between((Between)node);
        } else if (node instanceof In) {
            builder.inOperator((In)node);
        } else if (node instanceof Like) {
            builder.like((Like)node);
        } else if (node instanceof IsNull) {
            builder.isNull((IsNull)node);
        } else if (node instanceof TemporalOperation) {
            builder.temporalOperation((TemporalOperation)node);
        } else if (node instanceof SpatialOperation) {
            builder.spatialOperation((SpatialOperation)node);
        } else if (node instanceof ArrayOperation) {
            builder.arrayOperation((ArrayOperation)node);
        }
        return builder.build();
    }

    @Value.Check
    default public void check() {
        int count = this.getExpressions().size();
        Preconditions.checkState(count == 1, "a cql predicate must have exactly one child, found %s", count);
    }

    @JsonIgnore
    @Value.Derived
    @Value.Auxiliary
    default public List<CqlNode> getExpressions() {
        return ImmutableList.of(this.getAnd(), this.getOr(), this.getNot(), this.getEq(), this.getNeq(), this.getGt(), this.getGte(), this.getLt(), this.getLte(), this.getLike(), this.getBetween(), this.getInOperator(), new Optional[]{this.getIsNull(), this.getSpatialOperation(), this.getTemporalOperation(), this.getArrayOperation()}).stream().filter(Optional::isPresent).map(Optional::get).collect(ImmutableList.toImmutableList());
    }

    @Override
    default public <T> T accept(CqlVisitor<T> visitor) {
        T expression = this.getExpressions().get(0).accept(visitor);
        return (T)visitor.visit(this, Lists.newArrayList(expression));
    }
}

