/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.cql.domain;

import de.ii.xtraplatform.cql.domain.And;
import de.ii.xtraplatform.cql.domain.ArrayOperation;
import de.ii.xtraplatform.cql.domain.Between;
import de.ii.xtraplatform.cql.domain.CqlNode;
import de.ii.xtraplatform.cql.domain.CqlPredicate;
import de.ii.xtraplatform.cql.domain.CqlVisitor;
import de.ii.xtraplatform.cql.domain.Eq;
import de.ii.xtraplatform.cql.domain.Gt;
import de.ii.xtraplatform.cql.domain.Gte;
import de.ii.xtraplatform.cql.domain.ImmutableCqlFilter;
import de.ii.xtraplatform.cql.domain.In;
import de.ii.xtraplatform.cql.domain.IsNull;
import de.ii.xtraplatform.cql.domain.Like;
import de.ii.xtraplatform.cql.domain.Lt;
import de.ii.xtraplatform.cql.domain.Lte;
import de.ii.xtraplatform.cql.domain.Neq;
import de.ii.xtraplatform.cql.domain.Not;
import de.ii.xtraplatform.cql.domain.Or;
import de.ii.xtraplatform.cql.domain.SpatialOperation;
import de.ii.xtraplatform.cql.domain.TemporalOperation;
import shadow.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.com.google.common.collect.Lists;
import shadow.org.immutables.value.Value;

@JsonDeserialize(builder=ImmutableCqlFilter.Builder.class)
@Value.Immutable
public interface CqlFilter
extends CqlPredicate {
    public static CqlFilter of(CqlNode node) {
        if (node instanceof CqlFilter) {
            return CqlFilter.of(((CqlFilter)node).getExpressions().get(0));
        }
        if (node instanceof CqlPredicate) {
            return CqlFilter.of(((CqlPredicate)node).getExpressions().get(0));
        }
        ImmutableCqlFilter.Builder builder = new ImmutableCqlFilter.Builder();
        if (node instanceof And) {
            builder.and((And)node);
        } else if (node instanceof Or) {
            builder.or((Or)node);
        } else if (node instanceof Not) {
            builder.not((Not)node);
        } else if (node instanceof Eq) {
            builder.eq((Eq)node);
        } else if (node instanceof Neq) {
            builder.neq((Neq)node);
        } else if (node instanceof Gt) {
            builder.gt((Gt)node);
        } else if (node instanceof Gte) {
            builder.gte((Gte)node);
        } else if (node instanceof Lt) {
            builder.lt((Lt)node);
        } else if (node instanceof Lte) {
            builder.lte((Lte)node);
        } else if (node instanceof Between) {
            builder.between((Between)node);
        } else if (node instanceof In) {
            builder.inOperator((In)node);
        } else if (node instanceof Like) {
            builder.like((Like)node);
        } else if (node instanceof IsNull) {
            builder.isNull((IsNull)node);
        } else if (node instanceof TemporalOperation) {
            builder.temporalOperation((TemporalOperation)node);
        } else if (node instanceof SpatialOperation) {
            builder.spatialOperation((SpatialOperation)node);
        } else if (node instanceof ArrayOperation) {
            builder.arrayOperation((ArrayOperation)node);
        }
        return builder.build();
    }

    @Override
    default public <T> T accept(CqlVisitor<T> visitor) {
        T expression = this.getExpressions().get(0).accept(visitor);
        return (T)visitor.visit(this, Lists.newArrayList(expression));
    }
}

