/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.cql.domain;

import de.ii.xtraplatform.cql.domain.CqlNode;
import de.ii.xtraplatform.cql.domain.CqlVisitor;
import de.ii.xtraplatform.cql.domain.Literal;
import de.ii.xtraplatform.cql.domain.Operand;
import java.util.List;
import shadow.com.google.common.base.Preconditions;
import shadow.com.google.common.collect.Lists;
import shadow.org.immutables.value.Value;

public interface BinaryOperation<T extends Literal>
extends CqlNode {
    public List<Operand> getOperands();

    @Value.Check
    default public void check() {
        int count = this.getOperands().size();
        Preconditions.checkState(count == 2, "a binary operation must have exactly two operands, found %s", count);
    }

    default public <U> U accept(CqlVisitor<U> visitor) {
        U operand1 = this.getOperands().get(0).accept(visitor);
        U operand2 = this.getOperands().get(1).accept(visitor);
        return (U)visitor.visit(this, Lists.newArrayList(operand1, operand2));
    }

    public static abstract class Builder<T extends Literal, U extends BinaryOperation<T>> {
        public abstract U build();

        public abstract Builder<T, U> operands(Iterable<? extends Operand> var1);
    }
}

