/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.cql.domain;

import de.ii.xtraplatform.cql.domain.CqlNode;
import de.ii.xtraplatform.cql.domain.CqlVisitor;
import de.ii.xtraplatform.cql.domain.Function;
import de.ii.xtraplatform.cql.domain.ImmutableBetween;
import de.ii.xtraplatform.cql.domain.NonBinaryScalarOperation;
import de.ii.xtraplatform.cql.domain.Operand;
import de.ii.xtraplatform.cql.domain.Property;
import de.ii.xtraplatform.cql.domain.Scalar;
import de.ii.xtraplatform.cql.domain.ScalarLiteral;
import java.util.List;
import java.util.Optional;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.com.google.common.base.Preconditions;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.common.collect.Lists;
import shadow.org.immutables.value.Value;

@JsonDeserialize(builder=ImmutableBetween.Builder.class)
@Value.Immutable
public interface Between
extends NonBinaryScalarOperation,
CqlNode {
    public static Between of(String property, ScalarLiteral scalarLiteral1, ScalarLiteral scalarLiteral2) {
        return new ImmutableBetween.Builder().value(Property.of(property)).lower(scalarLiteral1).upper(scalarLiteral2).build();
    }

    public static Between of(Property property, ScalarLiteral scalarLiteral1, ScalarLiteral scalarLiteral2) {
        return new ImmutableBetween.Builder().value(property).lower(scalarLiteral1).upper(scalarLiteral2).build();
    }

    public static Between ofFunction(Function function, ScalarLiteral scalarLiteral1, ScalarLiteral scalarLiteral2) {
        return new ImmutableBetween.Builder().value(function).lower(scalarLiteral1).upper(scalarLiteral2).build();
    }

    public Optional<Scalar> getValue();

    public Optional<Scalar> getLower();

    public Optional<Scalar> getUpper();

    @Value.Check
    default public void check() {
        int count = this.getOperands().size();
        Preconditions.checkState(count == 3, "a BETWEEN operation must have exactly three operands, found %s", count);
    }

    @JsonIgnore
    @Value.Derived
    @Value.Auxiliary
    default public List<Operand> getOperands() {
        return ImmutableList.of(this.getValue(), this.getLower(), this.getUpper()).stream().filter(Optional::isPresent).map(Optional::get).collect(ImmutableList.toImmutableList());
    }

    default public <U> U accept(CqlVisitor<U> visitor) {
        U operand = this.getValue().get().accept(visitor);
        U lower = this.getLower().get().accept(visitor);
        U upper = this.getUpper().get().accept(visitor);
        return (U)visitor.visit(this, Lists.newArrayList(operand, lower, upper));
    }

    public static abstract class Builder {
        public abstract Between build();

        public abstract Builder value(Scalar var1);

        public abstract Builder lower(Scalar var1);

        public abstract Builder upper(Scalar var1);
    }
}

