/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.codelists.domain;

import de.ii.xtraplatform.codelists.domain.CodelistData;
import de.ii.xtraplatform.store.domain.Value;
import de.ii.xtraplatform.store.domain.entities.EntityData;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.common.collect.ImmutableMap;
import shadow.com.google.common.primitives.Longs;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CodelistData", generator="Immutables")
@Immutable
public final class ImmutableCodelistData
implements CodelistData {
    private final long storageVersion;
    private final String id;
    private final long createdAt;
    private final long lastModified;
    private final long entityStorageVersion;
    private final transient long entitySchemaVersion;
    @Nullable
    private final String entitySubType;
    private final String label;
    private final ImmutableMap<String, String> entries;
    private final CodelistData.IMPORT_TYPE sourceType;
    @Nullable
    private final String sourceUrl;
    @Nullable
    private final String fallback;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableCodelistData(Builder builder) {
        this.id = builder.id;
        this.entitySubType = builder.entitySubType;
        this.label = builder.label;
        this.entries = builder.entries.build();
        this.sourceType = builder.sourceType;
        this.sourceUrl = builder.sourceUrl;
        this.fallback = builder.fallback;
        if (builder.storageVersionIsSet()) {
            this.initShim.storageVersion(builder.storageVersion);
        }
        if (builder.createdAtIsSet()) {
            this.initShim.createdAt(builder.createdAt);
        }
        if (builder.lastModifiedIsSet()) {
            this.initShim.lastModified(builder.lastModified);
        }
        if (builder.entityStorageVersionIsSet()) {
            this.initShim.entityStorageVersion(builder.entityStorageVersion);
        }
        this.storageVersion = this.initShim.storageVersion();
        this.createdAt = this.initShim.getCreatedAt();
        this.lastModified = this.initShim.getLastModified();
        this.entityStorageVersion = this.initShim.getEntityStorageVersion();
        this.entitySchemaVersion = this.initShim.getEntitySchemaVersion();
        this.initShim = null;
    }

    private ImmutableCodelistData(long storageVersion, String id, long createdAt, long lastModified, long entityStorageVersion, @Nullable String entitySubType, String label, ImmutableMap<String, String> entries, CodelistData.IMPORT_TYPE sourceType, @Nullable String sourceUrl, @Nullable String fallback) {
        this.initShim.storageVersion(storageVersion);
        this.id = id;
        this.initShim.createdAt(createdAt);
        this.initShim.lastModified(lastModified);
        this.initShim.entityStorageVersion(entityStorageVersion);
        this.entitySubType = entitySubType;
        this.label = label;
        this.entries = entries;
        this.sourceType = sourceType;
        this.sourceUrl = sourceUrl;
        this.fallback = fallback;
        this.storageVersion = this.initShim.storageVersion();
        this.createdAt = this.initShim.getCreatedAt();
        this.lastModified = this.initShim.getLastModified();
        this.entityStorageVersion = this.initShim.getEntityStorageVersion();
        this.entitySchemaVersion = this.initShim.getEntitySchemaVersion();
        this.initShim = null;
    }

    private long storageVersionInitialize() {
        return CodelistData.super.storageVersion();
    }

    private long getCreatedAtInitialize() {
        return CodelistData.super.getCreatedAt();
    }

    private long getLastModifiedInitialize() {
        return CodelistData.super.getLastModified();
    }

    private long getEntityStorageVersionInitialize() {
        return CodelistData.super.getEntityStorageVersion();
    }

    private long getEntitySchemaVersionInitialize() {
        return CodelistData.super.getEntitySchemaVersion();
    }

    @Override
    @JsonProperty(value="storageVersion")
    @JsonIgnore
    public long storageVersion() {
        InitShim shim = this.initShim;
        return shim != null ? shim.storageVersion() : this.storageVersion;
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="createdAt")
    public long getCreatedAt() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getCreatedAt() : this.createdAt;
    }

    @Override
    @JsonProperty(value="lastModified")
    public long getLastModified() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getLastModified() : this.lastModified;
    }

    @Override
    @JsonProperty(value="entityStorageVersion")
    public long getEntityStorageVersion() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getEntityStorageVersion() : this.entityStorageVersion;
    }

    @Override
    @JsonProperty(value="entitySchemaVersion")
    @JsonIgnore
    public long getEntitySchemaVersion() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getEntitySchemaVersion() : this.entitySchemaVersion;
    }

    @Override
    @JsonProperty(value="entitySubType")
    @JsonIgnore
    public Optional<String> getEntitySubType() {
        return Optional.ofNullable(this.entitySubType);
    }

    @Override
    @JsonProperty(value="label")
    public String getLabel() {
        return this.label;
    }

    @JsonProperty(value="entries")
    public ImmutableMap<String, String> getEntries() {
        return this.entries;
    }

    @Override
    @JsonProperty(value="sourceType")
    public CodelistData.IMPORT_TYPE getSourceType() {
        return this.sourceType;
    }

    @Override
    @JsonProperty(value="sourceUrl")
    public Optional<String> getSourceUrl() {
        return Optional.ofNullable(this.sourceUrl);
    }

    @Override
    @JsonProperty(value="fallback")
    public Optional<String> getFallback() {
        return Optional.ofNullable(this.fallback);
    }

    public final ImmutableCodelistData withStorageVersion(long value) {
        if (this.storageVersion == value) {
            return this;
        }
        return new ImmutableCodelistData(value, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.entitySubType, this.label, this.entries, this.sourceType, this.sourceUrl, this.fallback);
    }

    public final ImmutableCodelistData withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableCodelistData(this.storageVersion, newValue, this.createdAt, this.lastModified, this.entityStorageVersion, this.entitySubType, this.label, this.entries, this.sourceType, this.sourceUrl, this.fallback);
    }

    public final ImmutableCodelistData withCreatedAt(long value) {
        if (this.createdAt == value) {
            return this;
        }
        return new ImmutableCodelistData(this.storageVersion, this.id, value, this.lastModified, this.entityStorageVersion, this.entitySubType, this.label, this.entries, this.sourceType, this.sourceUrl, this.fallback);
    }

    public final ImmutableCodelistData withLastModified(long value) {
        if (this.lastModified == value) {
            return this;
        }
        return new ImmutableCodelistData(this.storageVersion, this.id, this.createdAt, value, this.entityStorageVersion, this.entitySubType, this.label, this.entries, this.sourceType, this.sourceUrl, this.fallback);
    }

    public final ImmutableCodelistData withEntityStorageVersion(long value) {
        if (this.entityStorageVersion == value) {
            return this;
        }
        return new ImmutableCodelistData(this.storageVersion, this.id, this.createdAt, this.lastModified, value, this.entitySubType, this.label, this.entries, this.sourceType, this.sourceUrl, this.fallback);
    }

    public final ImmutableCodelistData withEntitySubType(String value) {
        String newValue = Objects.requireNonNull(value, "entitySubType");
        if (Objects.equals(this.entitySubType, newValue)) {
            return this;
        }
        return new ImmutableCodelistData(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, newValue, this.label, this.entries, this.sourceType, this.sourceUrl, this.fallback);
    }

    public final ImmutableCodelistData withEntitySubType(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.entitySubType, value)) {
            return this;
        }
        return new ImmutableCodelistData(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, value, this.label, this.entries, this.sourceType, this.sourceUrl, this.fallback);
    }

    public final ImmutableCodelistData withLabel(String value) {
        String newValue = Objects.requireNonNull(value, "label");
        if (this.label.equals(newValue)) {
            return this;
        }
        return new ImmutableCodelistData(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.entitySubType, newValue, this.entries, this.sourceType, this.sourceUrl, this.fallback);
    }

    public final ImmutableCodelistData withEntries(Map<String, ? extends String> entries) {
        if (this.entries == entries) {
            return this;
        }
        ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
        return new ImmutableCodelistData(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.entitySubType, this.label, newValue, this.sourceType, this.sourceUrl, this.fallback);
    }

    public final ImmutableCodelistData withSourceType(CodelistData.IMPORT_TYPE value) {
        if (this.sourceType == value) {
            return this;
        }
        CodelistData.IMPORT_TYPE newValue = Objects.requireNonNull(value, "sourceType");
        if (this.sourceType.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableCodelistData(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.entitySubType, this.label, this.entries, newValue, this.sourceUrl, this.fallback);
    }

    public final ImmutableCodelistData withSourceUrl(String value) {
        String newValue = Objects.requireNonNull(value, "sourceUrl");
        if (Objects.equals(this.sourceUrl, newValue)) {
            return this;
        }
        return new ImmutableCodelistData(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.entitySubType, this.label, this.entries, this.sourceType, newValue, this.fallback);
    }

    public final ImmutableCodelistData withSourceUrl(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.sourceUrl, value)) {
            return this;
        }
        return new ImmutableCodelistData(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.entitySubType, this.label, this.entries, this.sourceType, value, this.fallback);
    }

    public final ImmutableCodelistData withFallback(String value) {
        String newValue = Objects.requireNonNull(value, "fallback");
        if (Objects.equals(this.fallback, newValue)) {
            return this;
        }
        return new ImmutableCodelistData(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.entitySubType, this.label, this.entries, this.sourceType, this.sourceUrl, newValue);
    }

    public final ImmutableCodelistData withFallback(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.fallback, value)) {
            return this;
        }
        return new ImmutableCodelistData(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.entitySubType, this.label, this.entries, this.sourceType, this.sourceUrl, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCodelistData && this.equalTo((ImmutableCodelistData)another);
    }

    private boolean equalTo(ImmutableCodelistData another) {
        return this.storageVersion == another.storageVersion && this.id.equals(another.id) && this.createdAt == another.createdAt && this.lastModified == another.lastModified && this.entityStorageVersion == another.entityStorageVersion && this.entitySchemaVersion == another.entitySchemaVersion && Objects.equals(this.entitySubType, another.entitySubType) && this.label.equals(another.label) && this.entries.equals(another.entries) && this.sourceType.equals((Object)another.sourceType) && Objects.equals(this.sourceUrl, another.sourceUrl) && Objects.equals(this.fallback, another.fallback);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Longs.hashCode(this.storageVersion);
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + Longs.hashCode(this.createdAt);
        h += (h << 5) + Longs.hashCode(this.lastModified);
        h += (h << 5) + Longs.hashCode(this.entityStorageVersion);
        h += (h << 5) + Longs.hashCode(this.entitySchemaVersion);
        h += (h << 5) + Objects.hashCode(this.entitySubType);
        h += (h << 5) + this.label.hashCode();
        h += (h << 5) + this.entries.hashCode();
        h += (h << 5) + this.sourceType.hashCode();
        h += (h << 5) + Objects.hashCode(this.sourceUrl);
        h += (h << 5) + Objects.hashCode(this.fallback);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("CodelistData").omitNullValues().add("storageVersion", this.storageVersion).add("id", this.id).add("createdAt", this.createdAt).add("lastModified", this.lastModified).add("entityStorageVersion", this.entityStorageVersion).add("entitySchemaVersion", this.entitySchemaVersion).add("entitySubType", this.entitySubType).add("label", this.label).add("entries", this.entries).add("sourceType", (Object)this.sourceType).add("sourceUrl", this.sourceUrl).add("fallback", this.fallback).toString();
    }

    public static ImmutableCodelistData copyOf(CodelistData instance) {
        if (instance instanceof ImmutableCodelistData) {
            return (ImmutableCodelistData)instance;
        }
        return new Builder().from(instance).build();
    }

    @Generated(from="CodelistData", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    extends CodelistData.Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_LABEL = 2L;
        private static final long INIT_BIT_SOURCE_TYPE = 4L;
        private static final long OPT_BIT_STORAGE_VERSION = 1L;
        private static final long OPT_BIT_CREATED_AT = 2L;
        private static final long OPT_BIT_LAST_MODIFIED = 4L;
        private static final long OPT_BIT_ENTITY_STORAGE_VERSION = 8L;
        private long initBits = 7L;
        private long optBits;
        private long storageVersion;
        @Nullable
        private String id;
        private long createdAt;
        private long lastModified;
        private long entityStorageVersion;
        @Nullable
        private String entitySubType;
        @Nullable
        private String label;
        private ImmutableMap.Builder<String, String> entries = ImmutableMap.builder();
        @Nullable
        private CodelistData.IMPORT_TYPE sourceType;
        @Nullable
        private String sourceUrl;
        @Nullable
        private String fallback;

        @Override
        @CanIgnoreReturnValue
        public final Builder from(Value instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(EntityData instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(CodelistData instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Value instance;
            if (object instanceof Value) {
                instance = (Value)object;
                this.storageVersion(instance.storageVersion());
            }
            if (object instanceof EntityData) {
                instance = (EntityData)object;
                this.createdAt(instance.getCreatedAt());
                this.entityStorageVersion(instance.getEntityStorageVersion());
                this.id(instance.getId());
                this.lastModified(instance.getLastModified());
                Optional<String> entitySubTypeOptional = instance.getEntitySubType();
                if (entitySubTypeOptional.isPresent()) {
                    this.entitySubType(entitySubTypeOptional);
                }
            }
            if (object instanceof CodelistData) {
                instance = (CodelistData)object;
                Optional<String> sourceUrlOptional = instance.getSourceUrl();
                if (sourceUrlOptional.isPresent()) {
                    this.sourceUrl(sourceUrlOptional);
                }
                this.putAllEntries(instance.getEntries());
                this.label(instance.getLabel());
                this.sourceType(instance.getSourceType());
                Optional<String> fallbackOptional = instance.getFallback();
                if (fallbackOptional.isPresent()) {
                    this.fallback(fallbackOptional);
                }
            }
        }

        @JsonProperty(value="storageVersion")
        @JsonIgnore
        @CanIgnoreReturnValue
        public final Builder storageVersion(long storageVersion) {
            this.storageVersion = storageVersion;
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="createdAt")
        @CanIgnoreReturnValue
        public final Builder createdAt(long createdAt) {
            this.createdAt = createdAt;
            this.optBits |= 2L;
            return this;
        }

        @JsonProperty(value="lastModified")
        @CanIgnoreReturnValue
        public final Builder lastModified(long lastModified) {
            this.lastModified = lastModified;
            this.optBits |= 4L;
            return this;
        }

        @JsonProperty(value="entityStorageVersion")
        @CanIgnoreReturnValue
        public final Builder entityStorageVersion(long entityStorageVersion) {
            this.entityStorageVersion = entityStorageVersion;
            this.optBits |= 8L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder entitySubType(String entitySubType) {
            this.entitySubType = Objects.requireNonNull(entitySubType, "entitySubType");
            return this;
        }

        @JsonProperty(value="entitySubType")
        @JsonIgnore
        @CanIgnoreReturnValue
        public final Builder entitySubType(Optional<String> entitySubType) {
            this.entitySubType = entitySubType.orElse(null);
            return this;
        }

        @JsonProperty(value="label")
        @CanIgnoreReturnValue
        public final Builder label(String label) {
            this.label = Objects.requireNonNull(label, "label");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putEntries(String key, String value) {
            this.entries.put(key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putEntries(Map.Entry<String, ? extends String> entry) {
            this.entries.put(entry);
            return this;
        }

        @JsonProperty(value="entries")
        @CanIgnoreReturnValue
        public final Builder entries(Map<String, ? extends String> entries) {
            this.entries = ImmutableMap.builder();
            return this.putAllEntries(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllEntries(Map<String, ? extends String> entries) {
            this.entries.putAll(entries);
            return this;
        }

        @JsonProperty(value="sourceType")
        @CanIgnoreReturnValue
        public final Builder sourceType(CodelistData.IMPORT_TYPE sourceType) {
            this.sourceType = Objects.requireNonNull(sourceType, "sourceType");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sourceUrl(String sourceUrl) {
            this.sourceUrl = Objects.requireNonNull(sourceUrl, "sourceUrl");
            return this;
        }

        @JsonProperty(value="sourceUrl")
        @CanIgnoreReturnValue
        public final Builder sourceUrl(Optional<String> sourceUrl) {
            this.sourceUrl = sourceUrl.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder fallback(String fallback) {
            this.fallback = Objects.requireNonNull(fallback, "fallback");
            return this;
        }

        @JsonProperty(value="fallback")
        @CanIgnoreReturnValue
        public final Builder fallback(Optional<String> fallback) {
            this.fallback = fallback.orElse(null);
            return this;
        }

        @Override
        public ImmutableCodelistData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCodelistData(this);
        }

        private boolean storageVersionIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean createdAtIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean lastModifiedIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean entityStorageVersionIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("label");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("sourceType");
            }
            return "Cannot build CodelistData, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="CodelistData", generator="Immutables")
    private final class InitShim {
        private byte storageVersionBuildStage = 0;
        private long storageVersion;
        private byte createdAtBuildStage = 0;
        private long createdAt;
        private byte lastModifiedBuildStage = 0;
        private long lastModified;
        private byte entityStorageVersionBuildStage = 0;
        private long entityStorageVersion;
        private byte entitySchemaVersionBuildStage = 0;
        private long entitySchemaVersion;

        private InitShim() {
        }

        long storageVersion() {
            if (this.storageVersionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.storageVersionBuildStage == 0) {
                this.storageVersionBuildStage = (byte)-1;
                this.storageVersion = ImmutableCodelistData.this.storageVersionInitialize();
                this.storageVersionBuildStage = 1;
            }
            return this.storageVersion;
        }

        void storageVersion(long storageVersion) {
            this.storageVersion = storageVersion;
            this.storageVersionBuildStage = 1;
        }

        long getCreatedAt() {
            if (this.createdAtBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.createdAtBuildStage == 0) {
                this.createdAtBuildStage = (byte)-1;
                this.createdAt = ImmutableCodelistData.this.getCreatedAtInitialize();
                this.createdAtBuildStage = 1;
            }
            return this.createdAt;
        }

        void createdAt(long createdAt) {
            this.createdAt = createdAt;
            this.createdAtBuildStage = 1;
        }

        long getLastModified() {
            if (this.lastModifiedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.lastModifiedBuildStage == 0) {
                this.lastModifiedBuildStage = (byte)-1;
                this.lastModified = ImmutableCodelistData.this.getLastModifiedInitialize();
                this.lastModifiedBuildStage = 1;
            }
            return this.lastModified;
        }

        void lastModified(long lastModified) {
            this.lastModified = lastModified;
            this.lastModifiedBuildStage = 1;
        }

        long getEntityStorageVersion() {
            if (this.entityStorageVersionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.entityStorageVersionBuildStage == 0) {
                this.entityStorageVersionBuildStage = (byte)-1;
                this.entityStorageVersion = ImmutableCodelistData.this.getEntityStorageVersionInitialize();
                this.entityStorageVersionBuildStage = 1;
            }
            return this.entityStorageVersion;
        }

        void entityStorageVersion(long entityStorageVersion) {
            this.entityStorageVersion = entityStorageVersion;
            this.entityStorageVersionBuildStage = 1;
        }

        long getEntitySchemaVersion() {
            if (this.entitySchemaVersionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.entitySchemaVersionBuildStage == 0) {
                this.entitySchemaVersionBuildStage = (byte)-1;
                this.entitySchemaVersion = ImmutableCodelistData.this.getEntitySchemaVersionInitialize();
                this.entitySchemaVersionBuildStage = 1;
            }
            return this.entitySchemaVersion;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.storageVersionBuildStage == -1) {
                attributes.add("storageVersion");
            }
            if (this.createdAtBuildStage == -1) {
                attributes.add("createdAt");
            }
            if (this.lastModifiedBuildStage == -1) {
                attributes.add("lastModified");
            }
            if (this.entityStorageVersionBuildStage == -1) {
                attributes.add("entityStorageVersion");
            }
            if (this.entitySchemaVersionBuildStage == -1) {
                attributes.add("entitySchemaVersion");
            }
            return "Cannot build CodelistData, attribute initializers form cycle " + attributes;
        }
    }
}

