/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.codelists.app;

import dagger.assisted.Assisted;
import dagger.assisted.AssistedInject;
import de.ii.xtraplatform.codelists.domain.Codelist;
import de.ii.xtraplatform.codelists.domain.CodelistData;
import de.ii.xtraplatform.store.domain.entities.AbstractPersistentEntity;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodelistEntity
extends AbstractPersistentEntity<CodelistData>
implements Codelist {
    private static final Logger LOGGER = LoggerFactory.getLogger(CodelistEntity.class);

    @AssistedInject
    public CodelistEntity(@Assisted CodelistData data) {
        super(data);
    }

    @Override
    protected void onStarted() {
        LOGGER.info("Codelist with id '{}' loaded successfully.", (Object)this.getId());
    }

    @Override
    protected void onReloaded() {
        LOGGER.info("Codelist with id '{}' reloaded successfully.", (Object)this.getId());
    }

    @Override
    public String getValue(String key) {
        return Optional.ofNullable(this.getData().getEntries().get(key)).orElse(this.getData().getFallback().orElse(key));
    }

    @Override
    public CodelistData getData() {
        return (CodelistData)super.getData();
    }
}

