/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.base.domain.util;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class LambdaWithException {
    public static <T, R> Function<T, R> mayThrow(FunctionWithException<T, R> fe) {
        return arg -> {
            try {
                return fe.apply(arg);
            }
            catch (Error | RuntimeException ex) {
                throw ex;
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        };
    }

    public static <T, R, E extends Exception> Consumer<T> consumerMayThrow(ConsumerWithException<T, E> ce) {
        return arg -> {
            try {
                ce.apply(arg);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static <T, U, E extends Exception> BiConsumer<T, U> biConsumerMayThrow(BiConsumerWithException<T, U, E> ce) {
        return (arg, arg2) -> {
            try {
                ce.apply(arg, arg2);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        };
    }

    public static <T, E extends Exception> Supplier<T> supplierMayThrow(SupplierWithException<T, E> se) {
        return () -> {
            try {
                return se.get();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    @FunctionalInterface
    public static interface SupplierWithException<T, E extends Exception> {
        public T get() throws E;
    }

    @FunctionalInterface
    public static interface BiConsumerWithException<T, U, E extends Exception> {
        public void apply(T var1, U var2) throws E;
    }

    @FunctionalInterface
    public static interface ConsumerWithException<T, E extends Exception> {
        public void apply(T var1) throws E;
    }

    @FunctionalInterface
    public static interface FunctionWithException<T, R> {
        public R apply(T var1) throws Throwable;
    }
}

