/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.base.domain;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.core.spi.FilterReply;
import de.ii.xtraplatform.base.domain.LogContext;
import java.util.Objects;
import org.slf4j.Marker;

public class LoggingFilter
extends TurboFilter {
    private boolean showThirdPartyLoggers;
    private boolean sqlQueries;
    private boolean sqlResults;
    private boolean configDumps;
    private boolean stackTraces;
    private boolean wiring;

    public LoggingFilter(boolean showThirdPartyLoggers, boolean sqlQueries, boolean sqlResults, boolean configDumps, boolean stackTraces, boolean wiring) {
        this.showThirdPartyLoggers = showThirdPartyLoggers;
        this.sqlQueries = sqlQueries;
        this.sqlResults = sqlResults;
        this.configDumps = configDumps;
        this.stackTraces = stackTraces;
        this.wiring = wiring;
    }

    @Override
    public FilterReply decide(Marker marker, Logger logger, Level level, String format, Object[] params, Throwable t) {
        if (this.sqlQueries && (Objects.equals(marker, LogContext.MARKER.SQL) || logger.getName().equals("slick.jdbc.JdbcBackend.benchmark"))) {
            return FilterReply.ACCEPT;
        }
        if (this.sqlResults && (Objects.equals(marker, LogContext.MARKER.SQL_RESULT) || logger.getName().equals("slick.jdbc.StatementInvoker.result"))) {
            return FilterReply.ACCEPT;
        }
        if (this.configDumps && Objects.equals(marker, LogContext.MARKER.DUMP)) {
            return FilterReply.ACCEPT;
        }
        if (this.stackTraces && Objects.equals(marker, LogContext.MARKER.STACKTRACE)) {
            return FilterReply.ACCEPT;
        }
        if (this.wiring && Objects.equals(marker, LogContext.MARKER.DI)) {
            return FilterReply.ACCEPT;
        }
        if (Objects.isNull(marker) && (this.showThirdPartyLoggers || logger.getName().startsWith("de.ii"))) {
            return FilterReply.NEUTRAL;
        }
        return FilterReply.DENY;
    }

    public boolean isShowThirdPartyLoggers() {
        return this.showThirdPartyLoggers;
    }

    public void setShowThirdPartyLoggers(boolean showThirdPartyLoggers) {
        this.showThirdPartyLoggers = showThirdPartyLoggers;
    }

    public boolean isSqlQueries() {
        return this.sqlQueries;
    }

    public void setSqlQueries(boolean sqlQueries) {
        this.sqlQueries = sqlQueries;
    }

    public boolean isSqlResults() {
        return this.sqlResults;
    }

    public void setSqlResults(boolean sqlResults) {
        this.sqlResults = sqlResults;
    }

    public boolean isConfigDumps() {
        return this.configDumps;
    }

    public void setConfigDumps(boolean configDumps) {
        this.configDumps = configDumps;
    }

    public boolean isStackTraces() {
        return this.stackTraces;
    }

    public void setStackTraces(boolean stackTraces) {
        this.stackTraces = stackTraces;
    }

    public boolean isWiring() {
        return this.wiring;
    }

    public void setWiring(boolean wiring) {
        this.wiring = wiring;
    }
}

