/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.base.domain;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.MDC;
import org.slf4j.Marker;
import shadow.org.slf4j.event.Level;

public class LogContext {
    public static boolean has(CONTEXT context) {
        return Objects.nonNull(MDC.get(context.name()));
    }

    public static String get(CONTEXT context) {
        return MDC.get(context.name());
    }

    public static void put(CONTEXT context, String value) {
        MDC.put(context.name(), value);
    }

    public static void remove(CONTEXT context) {
        MDC.remove(context.name());
    }

    public static MDC.MDCCloseable putCloseable(CONTEXT context, String value) {
        return MDC.putCloseable(context.name(), value);
    }

    public static Runnable withMdc(Runnable runnable) {
        Map<String, String> mdc = MDC.getCopyOfContextMap();
        if (Objects.nonNull(mdc)) {
            return () -> {
                MDC.setContextMap(mdc);
                runnable.run();
            };
        }
        return runnable;
    }

    public static <U> Callable<U> withMdc(Callable<U> callable) {
        Map<String, String> mdc = MDC.getCopyOfContextMap();
        if (Objects.nonNull(mdc)) {
            return () -> {
                MDC.setContextMap(mdc);
                return callable.call();
            };
        }
        return callable;
    }

    public static <U> Consumer<U> withMdc(Consumer<U> consumer) {
        Map<String, String> mdc = MDC.getCopyOfContextMap();
        if (Objects.nonNull(mdc)) {
            return u -> {
                MDC.setContextMap(mdc);
                consumer.accept(u);
            };
        }
        return consumer;
    }

    public static <T, U, V> BiFunction<T, U, V> withMdc(BiFunction<T, U, V> biFunction) {
        Map<String, String> mdc = MDC.getCopyOfContextMap();
        if (Objects.nonNull(mdc)) {
            return (t, u) -> {
                MDC.setContextMap(mdc);
                return biFunction.apply(t, u);
            };
        }
        return biFunction;
    }

    public static void error(Logger logger, Throwable throwable, String messagePrefix, Object ... messagePrefixArgs) {
        Object[] args = Arrays.copyOf(messagePrefixArgs, messagePrefixArgs.length + 1);
        args[messagePrefixArgs.length] = LogContext.getMessage(throwable);
        LogContext.logThrowable(logger, Level.ERROR, throwable, (String)(messagePrefix.isEmpty() ? "{}" : messagePrefix + ": {}"), args);
    }

    public static void errorAsInfo(Logger logger, Throwable throwable, String messagePrefix, Object ... messagePrefixArgs) {
        Object[] args = Arrays.copyOf(messagePrefixArgs, messagePrefixArgs.length + 1);
        args[messagePrefixArgs.length] = LogContext.getMessage(throwable);
        LogContext.logThrowable(logger, Level.INFO, throwable, messagePrefix + ": {}", args);
    }

    public static void errorAsDebug(Logger logger, Throwable throwable, String messagePrefix, Object ... messagePrefixArgs) {
        Object[] args = Arrays.copyOf(messagePrefixArgs, messagePrefixArgs.length + 1);
        args[messagePrefixArgs.length] = LogContext.getMessage(throwable);
        LogContext.logThrowable(logger, Level.DEBUG, throwable, messagePrefix + ": {}", args);
    }

    public static void errorChain(Logger logger, Throwable throwable, String messagePrefix, Object ... messagePrefixArgs) {
        Throwable current = throwable;
        int max = 3;
        int numMessages = 0;
        String[] messages = new String[max];
        Object prefix = messagePrefix;
        while (Objects.nonNull(current) && max > 0) {
            messages[numMessages] = LogContext.getMessage(current);
            prefix = (String)prefix + ": {}";
            ++numMessages;
            --max;
            current = current.getCause();
        }
        Object[] args = Arrays.copyOf(messagePrefixArgs, messagePrefixArgs.length + numMessages);
        if (numMessages >= 0) {
            System.arraycopy(messages, 0, args, messagePrefixArgs.length, numMessages);
        }
        LogContext.logThrowable(logger, Level.ERROR, throwable, (String)prefix, args);
    }

    private static void logThrowable(Logger logger, Level level, Throwable throwable, String message, Object ... messageArgs) {
        if (level == Level.DEBUG) {
            logger.debug(message, messageArgs);
        } else if (level == Level.INFO) {
            logger.info(message, messageArgs);
        } else if (level == Level.WARN) {
            logger.warn(message, messageArgs);
        } else {
            logger.error(message, messageArgs);
        }
        if (logger.isDebugEnabled(MARKER.STACKTRACE)) {
            logger.debug((Marker)MARKER.STACKTRACE, "Stacktrace:", throwable);
        }
    }

    private static String getMessage(Throwable throwable) {
        return Objects.nonNull(throwable.getMessage()) ? throwable.getMessage() : String.format("%s at %s", throwable.getClass().getSimpleName(), throwable.getStackTrace()[0].toString());
    }

    public static UUID generateRandomUuid() {
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        long mostSig = ((Random)rnd).nextLong();
        long leastSig = ((Random)rnd).nextLong();
        mostSig &= 0xFFFFFFFFFFFF0FFFL;
        leastSig &= 0x3FFFFFFFFFFFFFFFL;
        return new UUID(mostSig |= 0x4000L, leastSig |= Long.MIN_VALUE);
    }

    private static interface MyMarker
    extends Marker {
        @Override
        default public void add(Marker reference) {
        }

        @Override
        default public boolean remove(Marker reference) {
            return false;
        }

        @Override
        default public boolean hasChildren() {
            return false;
        }

        @Override
        default public boolean hasReferences() {
            return false;
        }

        @Override
        default public Iterator<Marker> iterator() {
            return null;
        }

        @Override
        default public boolean contains(Marker other) {
            return false;
        }

        @Override
        default public boolean contains(String name) {
            return false;
        }
    }

    public static enum MARKER implements MyMarker
    {
        SQL,
        SQL_RESULT,
        STACKTRACE,
        DUMP,
        DI;


        public String toString() {
            return "#" + super.toString();
        }

        @Override
        public String getName() {
            return this.toString();
        }
    }

    public static enum CONTEXT {
        SERVICE,
        REQUEST;

    }
}

